/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.language.simple.SimpleBackwardsCompatibleParser;
import org.apache.camel.language.simple.SimpleExpressionParser;
import org.apache.camel.language.simple.SimplePredicateParser;
import org.apache.camel.language.simple.SimpleTokenizer;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PredicateToExpressionAdapter;

public class SimpleLanguage
extends LanguageSupport {
    private static final SimpleLanguage SIMPLE = new SimpleLanguage();
    protected boolean allowEscape = true;

    @Override
    public Predicate createPredicate(String expression) {
        ObjectHelper.notNull(expression, "expression");
        expression = this.loadResource(expression);
        Predicate answer = SimpleBackwardsCompatibleParser.parsePredicate(expression, this.allowEscape);
        if (answer == null) {
            SimplePredicateParser parser = new SimplePredicateParser(expression, this.allowEscape);
            answer = parser.parsePredicate();
        }
        return answer;
    }

    @Override
    public Expression createExpression(String expression) {
        ObjectHelper.notNull(expression, "expression");
        expression = this.loadResource(expression);
        Expression answer = SimpleBackwardsCompatibleParser.parseExpression(expression, this.allowEscape);
        if (answer == null) {
            SimpleExpressionParser parser = new SimpleExpressionParser(expression, this.allowEscape);
            answer = parser.parseExpression();
        }
        return answer;
    }

    public static Expression simple(String expression) {
        return SimpleLanguage.expression(expression);
    }

    public static Expression simple(String expression, Class<?> resultType) {
        return new SimpleLanguage().createExpression(expression, resultType);
    }

    public Expression createExpression(String expression, Class<?> resultType) {
        if (resultType == Boolean.class || resultType == Boolean.TYPE) {
            Predicate predicate = this.createPredicate(expression);
            return PredicateToExpressionAdapter.toExpression(predicate);
        }
        Expression exp = this.createExpression(expression);
        if (resultType != null) {
            exp = ExpressionBuilder.convertToExpression(exp, resultType);
        }
        return exp;
    }

    public static Expression expression(String expression) {
        return SIMPLE.createExpression(expression);
    }

    public static Predicate predicate(String predicate) {
        return SIMPLE.createPredicate(predicate);
    }

    public static boolean hasSimpleFunction(String expression) {
        return SimpleTokenizer.hasFunctionStartToken(expression);
    }

    public static void changeFunctionStartToken(String ... startToken) {
        SimpleTokenizer.changeFunctionStartToken(startToken);
    }

    public static void changeFunctionEndToken(String ... endToken) {
        SimpleTokenizer.changeFunctionEndToken(endToken);
    }

    public void setFunctionStartToken(String startToken) {
        SimpleLanguage.changeFunctionStartToken(startToken);
    }

    public void setFunctionEndToken(String endToken) {
        SimpleLanguage.changeFunctionEndToken(endToken);
    }
}

