/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.impl.ClientConnection;
import io.vertx.core.http.impl.FrameType;
import io.vertx.core.http.impl.VertxHttpHandler;
import io.vertx.core.http.impl.ws.WebSocketFrameImpl;
import io.vertx.core.http.impl.ws.WebSocketFrameInternal;
import io.vertx.core.impl.ContextImpl;
import java.util.Map;

class ClientHandler
extends VertxHttpHandler<ClientConnection> {
    private boolean closeFrameSent;
    private ContextImpl context;

    public ClientHandler(Channel ch, ContextImpl context, Map<Channel, ClientConnection> connectionMap) {
        super(connectionMap, ch);
        this.context = context;
    }

    @Override
    protected ContextImpl getContext(ClientConnection connection) {
        return this.context;
    }

    @Override
    protected void doMessageReceived(ClientConnection conn, ChannelHandlerContext ctx, Object msg) {
        if (conn == null) {
            return;
        }
        if (msg instanceof HttpObject) {
            HttpObject obj = (HttpObject)msg;
            DecoderResult result = obj.decoderResult();
            if (result.isFailure()) {
                conn.handleException(result.cause());
                conn.close();
                return;
            }
            if (msg instanceof HttpResponse) {
                HttpResponse response = (HttpResponse)obj;
                conn.handleResponse(response);
                return;
            }
            if (msg instanceof HttpContent) {
                HttpContent chunk = (HttpContent)obj;
                if (chunk.content().isReadable()) {
                    Buffer buff = Buffer.buffer(chunk.content().slice());
                    conn.handleResponseChunk(buff);
                }
                if (chunk instanceof LastHttpContent) {
                    conn.handleResponseEnd((LastHttpContent)chunk);
                }
                return;
            }
        } else if (msg instanceof WebSocketFrameInternal) {
            WebSocketFrameInternal frame = (WebSocketFrameInternal)msg;
            switch (frame.type()) {
                case BINARY: 
                case CONTINUATION: 
                case TEXT: {
                    conn.handleWsFrame(frame);
                    break;
                }
                case PING: {
                    ctx.writeAndFlush((Object)new WebSocketFrameImpl(FrameType.PONG, frame.getBinaryData()));
                    break;
                }
                case PONG: {
                    break;
                }
                case CLOSE: {
                    if (this.closeFrameSent) break;
                    ctx.writeAndFlush((Object)frame).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    this.closeFrameSent = true;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid type: " + (Object)((Object)frame.type()));
                }
            }
            return;
        }
        throw new IllegalStateException("Invalid object " + msg);
    }
}

