/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.context;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.context.ExpressionCapable;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.integration.context.IntegrationProperties;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class IntegrationObjectSupport
implements BeanNameAware,
NamedComponent,
ApplicationContextAware,
BeanFactoryAware,
InitializingBean,
ExpressionCapable {
    protected static final ExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ConversionService defaultConversionService = new DefaultConversionService();
    private volatile DestinationResolver<MessageChannel> channelResolver;
    private volatile String beanName;
    private volatile String componentName;
    private volatile BeanFactory beanFactory;
    private volatile TaskScheduler taskScheduler;
    private volatile Properties integrationProperties = IntegrationProperties.defaults();
    private volatile ConversionService conversionService;
    private volatile ApplicationContext applicationContext;
    private volatile MessageBuilderFactory messageBuilderFactory;
    private Expression expression;

    public final void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    @Override
    public final String getComponentName() {
        return StringUtils.hasText((String)this.componentName) ? this.componentName : this.beanName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    @Override
    public String getComponentType() {
        return null;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"'beanFactory' must not be null");
        this.beanFactory = beanFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Assert.notNull((Object)applicationContext, (String)"'applicationContext' must not be null");
        this.applicationContext = applicationContext;
    }

    public void setChannelResolver(DestinationResolver<MessageChannel> channelResolver) {
        Assert.notNull(channelResolver, (String)"'channelResolver' must not be null");
        this.channelResolver = channelResolver;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    public final void setPrimaryExpression(Expression expression) {
        this.expression = expression;
    }

    public final void afterPropertiesSet() {
        this.integrationProperties = IntegrationContextUtils.getIntegrationProperties(this.beanFactory);
        try {
            if (this.messageBuilderFactory == null) {
                this.messageBuilderFactory = this.beanFactory != null ? IntegrationUtils.getMessageBuilderFactory(this.beanFactory) : new DefaultMessageBuilderFactory();
            }
            this.onInit();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new BeanInitializationException("failed to initialize", (Throwable)e);
        }
    }

    protected void onInit() throws Exception {
    }

    protected final BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected TaskScheduler getTaskScheduler() {
        if (this.taskScheduler == null && this.beanFactory != null) {
            this.taskScheduler = IntegrationContextUtils.getTaskScheduler(this.beanFactory);
        }
        return this.taskScheduler;
    }

    protected DestinationResolver<MessageChannel> getChannelResolver() {
        if (this.channelResolver == null) {
            this.channelResolver = new BeanFactoryChannelResolver(this.beanFactory);
        }
        return this.channelResolver;
    }

    protected void setTaskScheduler(TaskScheduler taskScheduler) {
        Assert.notNull((Object)taskScheduler, (String)"taskScheduler must not be null");
        this.taskScheduler = taskScheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ConversionService getConversionService() {
        if (this.conversionService == null && this.beanFactory != null) {
            IntegrationObjectSupport integrationObjectSupport = this;
            synchronized (integrationObjectSupport) {
                if (this.conversionService == null) {
                    this.conversionService = IntegrationUtils.getConversionService(this.beanFactory);
                }
            }
            if (this.conversionService == null && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Unable to attempt conversion of Message payload types. Component '" + this.getComponentName() + "' has no explicit ConversionService reference, and there is no 'integrationConversionService' bean within the context."));
            }
        }
        return this.conversionService;
    }

    protected void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public String getApplicationContextId() {
        return this.applicationContext == null ? null : this.applicationContext.getId();
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected Properties getIntegrationProperties() {
        return this.integrationProperties;
    }

    protected MessageBuilderFactory getMessageBuilderFactory() {
        if (this.messageBuilderFactory == null) {
            this.messageBuilderFactory = new DefaultMessageBuilderFactory();
        }
        return this.messageBuilderFactory;
    }

    public void setMessageBuilderFactory(MessageBuilderFactory messageBuilderFactory) {
        this.messageBuilderFactory = messageBuilderFactory;
    }

    protected <T> T getIntegrationProperty(String key, Class<T> tClass) {
        return (T)this.defaultConversionService.convert((Object)this.integrationProperties.getProperty(key), tClass);
    }

    protected <T> T extractTypeIfPossible(Object targetObject, Class<T> expectedType) {
        if (targetObject == null) {
            return null;
        }
        if (expectedType.isAssignableFrom(targetObject.getClass())) {
            return (T)targetObject;
        }
        if (targetObject instanceof Advised) {
            TargetSource targetSource = ((Advised)targetObject).getTargetSource();
            if (targetSource == null) {
                return null;
            }
            try {
                return this.extractTypeIfPossible(targetSource.getTarget(), expectedType);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    public String toString() {
        return this.beanName != null ? this.beanName : super.toString();
    }
}

