/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.json;

import org.springframework.integration.support.json.BoonJsonObjectMapper;
import org.springframework.integration.support.json.Jackson2JsonObjectMapper;
import org.springframework.integration.support.json.JacksonJsonUtils;
import org.springframework.integration.support.json.JsonObjectMapper;
import org.springframework.util.ClassUtils;

public final class JsonObjectMapperProvider {
    private static final ClassLoader classLoader = JsonObjectMapperProvider.class.getClassLoader();
    private static final boolean boonPresent = ClassUtils.isPresent((String)"org.boon.json.ObjectMapper", (ClassLoader)classLoader);

    private JsonObjectMapperProvider() {
    }

    public static JsonObjectMapper<?, ?> newInstance() {
        if (JacksonJsonUtils.isJackson2Present()) {
            return new Jackson2JsonObjectMapper();
        }
        if (boonPresent) {
            return new BoonJsonObjectMapper();
        }
        throw new IllegalStateException("Neither jackson-databind.jar, nor boon.jar is present in the classpath.");
    }

    public static boolean jsonAvailable() {
        return JacksonJsonUtils.isJackson2Present() || boonPresent;
    }
}

