/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.util.Assert;

public class DynamicPeriodicTrigger
implements Trigger {
    private volatile long period;
    private volatile TimeUnit timeUnit;
    private volatile long initialDelay = 0L;
    private volatile boolean fixedRate = false;

    public DynamicPeriodicTrigger(long period) {
        this(period, TimeUnit.MILLISECONDS);
    }

    public DynamicPeriodicTrigger(long period, TimeUnit timeUnit) {
        Assert.isTrue((period >= 0L ? 1 : 0) != 0, (String)"period must not be negative");
        Assert.notNull((Object)((Object)timeUnit), (String)"timeUnit must not be null");
        this.timeUnit = timeUnit;
        this.period = this.timeUnit.toMillis(period);
    }

    public void setInitialDelay(long initialDelay) {
        Assert.isTrue((initialDelay >= 0L ? 1 : 0) != 0, (String)"initialDelay must not be negative");
        this.initialDelay = this.timeUnit.toMillis(initialDelay);
    }

    public void setFixedRate(boolean fixedRate) {
        this.fixedRate = fixedRate;
    }

    public Date nextExecutionTime(TriggerContext triggerContext) {
        if (triggerContext.lastScheduledExecutionTime() == null) {
            return new Date(System.currentTimeMillis() + this.initialDelay);
        }
        if (this.fixedRate) {
            return new Date(triggerContext.lastScheduledExecutionTime().getTime() + this.period);
        }
        return new Date(triggerContext.lastCompletionTime().getTime() + this.period);
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        Assert.isTrue((period >= 0L ? 1 : 0) != 0, (String)"period must not be negative");
        this.period = this.timeUnit.toMillis(period);
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        Assert.notNull((Object)((Object)timeUnit), (String)"timeUnit must not be null");
        this.timeUnit = timeUnit;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public boolean isFixedRate() {
        return this.fixedRate;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DynamicPeriodicTrigger)) {
            return false;
        }
        DynamicPeriodicTrigger other = (DynamicPeriodicTrigger)obj;
        return this.fixedRate == other.fixedRate && this.initialDelay == other.initialDelay && this.period == other.period;
    }

    public int hashCode() {
        return (this.fixedRate ? 14 : 41) + (int)(38L * this.period) + (int)(43L * this.initialDelay);
    }
}

