/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.cw;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.cw.CwConfiguration;
import org.apache.camel.component.aws.cw.CwProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.11.0", scheme="aws-cw", title="AWS CloudWatch", syntax="aws-cw:namespace", producerOnly=true, label="cloud,monitoring")
public class CwEndpoint
extends DefaultEndpoint {
    @UriParam
    private CwConfiguration configuration;
    private AmazonCloudWatch cloudWatchClient;

    @Deprecated
    public CwEndpoint(String uri, CamelContext context, CwConfiguration configuration) {
        super(uri, context);
        this.configuration = configuration;
    }

    public CwEndpoint(String uri, Component component, CwConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new CwProducer((Endpoint)this);
    }

    public boolean isSingleton() {
        return true;
    }

    public void doStart() throws Exception {
        super.doStart();
        AmazonCloudWatch amazonCloudWatch = this.cloudWatchClient = this.configuration.getAmazonCwClient() != null ? this.configuration.getAmazonCwClient() : this.createCloudWatchClient();
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getAmazonCwEndpoint())) {
            this.cloudWatchClient.setEndpoint(this.configuration.getAmazonCwEndpoint());
        }
    }

    public CwConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CwConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setCloudWatchClient(AmazonCloudWatch cloudWatchClient) {
        this.cloudWatchClient = cloudWatchClient;
    }

    public AmazonCloudWatch getCloudWatchClient() {
        return this.cloudWatchClient;
    }

    AmazonCloudWatch createCloudWatchClient() {
        AmazonCloudWatchClient client = null;
        ClientConfiguration clientConfiguration = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            clientConfiguration = new ClientConfiguration();
            clientConfiguration.setProxyHost(this.configuration.getProxyHost());
            clientConfiguration.setProxyPort(this.configuration.getProxyPort().intValue());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
            client = isClientConfigFound ? new AmazonCloudWatchClient((AWSCredentials)credentials, clientConfiguration) : new AmazonCloudWatchClient((AWSCredentials)credentials);
        } else {
            client = isClientConfigFound ? new AmazonCloudWatchClient() : new AmazonCloudWatchClient(clientConfiguration);
        }
        return client;
    }
}

