/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.background;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.background.BasicJavaScriptJob;
import java.io.IOException;
import java.net.URL;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class DownloadBehaviorJob
extends BasicJavaScriptJob {
    private static final Log LOG = LogFactory.getLog(DownloadBehaviorJob.class);
    private final URL url_;
    private final Function callback_;
    private final WebClient client_;

    DownloadBehaviorJob(URL url, Function callback, WebClient client) {
        this.url_ = url;
        this.callback_ = callback;
        this.client_ = client;
    }

    @Override
    public void run() {
        final Scriptable scope = this.callback_.getParentScope();
        WebRequest request = new WebRequest(this.url_);
        try {
            WebResponse webResponse = this.client_.loadWebResponse(request);
            String content = webResponse.getContentAsString();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Downloaded content: " + StringUtils.abbreviate((String)content, (int)512)));
            }
            final Object[] args = new Object[]{content};
            ContextAction action = new ContextAction(){

                public Object run(Context cx) {
                    DownloadBehaviorJob.this.callback_.call(cx, scope, scope, args);
                    return null;
                }
            };
            HtmlUnitContextFactory cf = this.client_.getJavaScriptEngine().getContextFactory();
            cf.call(action);
        }
        catch (IOException e) {
            LOG.error((Object)("Behavior #default#download: Cannot download " + this.url_), (Throwable)e);
        }
    }
}

