/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox.core;

import com.dropbox.core.DbxClient;
import com.dropbox.core.DbxEntry;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxWriteMode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.dropbox.dto.DropboxDelResult;
import org.apache.camel.component.dropbox.dto.DropboxFileDownloadResult;
import org.apache.camel.component.dropbox.dto.DropboxFileUploadResult;
import org.apache.camel.component.dropbox.dto.DropboxMoveResult;
import org.apache.camel.component.dropbox.dto.DropboxSearchResult;
import org.apache.camel.component.dropbox.util.DropboxException;
import org.apache.camel.component.dropbox.util.DropboxResultCode;
import org.apache.camel.component.dropbox.util.DropboxUploadMode;
import org.apache.camel.converter.stream.OutputStreamBuilder;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DropboxAPIFacade {
    private static final transient Logger LOG = LoggerFactory.getLogger(DropboxAPIFacade.class);
    private final DbxClient client;
    private final Exchange exchange;

    public DropboxAPIFacade(DbxClient client, Exchange exchange) {
        this.client = client;
        this.exchange = exchange;
    }

    public DropboxFileUploadResult put(String localPath, String remotePath, DropboxUploadMode mode) throws DropboxException {
        DbxEntry entry;
        String dropboxPath = remotePath == null ? localPath : remotePath;
        try {
            entry = this.client.getMetadata(dropboxPath);
        }
        catch (DbxException e) {
            throw new DropboxException(dropboxPath + " does not exist or can't obtain metadata");
        }
        File fileLocalPath = new File(localPath);
        if (fileLocalPath.isFile()) {
            DropboxFileUploadResult result;
            if (entry != null && !entry.isFile()) {
                throw new DropboxException(dropboxPath + " exists on dropbox and is not a file!");
            }
            if (entry == null && dropboxPath.endsWith("/")) {
                dropboxPath = dropboxPath + fileLocalPath.getName();
            }
            try {
                DbxEntry.File uploadedFile = this.putSingleFile(fileLocalPath, dropboxPath, mode);
                result = uploadedFile == null ? new DropboxFileUploadResult(dropboxPath, DropboxResultCode.KO) : new DropboxFileUploadResult(dropboxPath, DropboxResultCode.OK);
            }
            catch (Exception ex) {
                result = new DropboxFileUploadResult(dropboxPath, DropboxResultCode.KO);
            }
            return result;
        }
        LOG.debug("Uploading a dir...");
        if (entry != null && !entry.isFolder()) {
            throw new DropboxException(dropboxPath + " exists on dropbox and is not a folder!");
        }
        if (!dropboxPath.endsWith("/")) {
            dropboxPath = dropboxPath + "/";
        }
        String oldDropboxPath = dropboxPath;
        Collection listFiles = FileUtils.listFiles((File)fileLocalPath, null, (boolean)true);
        if (listFiles.isEmpty()) {
            throw new DropboxException(localPath + " doesn't contain any files");
        }
        HashMap<String, DropboxResultCode> resultMap = new HashMap<String, DropboxResultCode>(listFiles.size());
        for (File file : listFiles) {
            String absPath = file.getAbsolutePath();
            int indexRemainingPath = localPath.length();
            if (!localPath.endsWith("/")) {
                ++indexRemainingPath;
            }
            String remainingPath = absPath.substring(indexRemainingPath);
            dropboxPath = dropboxPath + remainingPath;
            try {
                LOG.debug("Uploading: {},{}", (Object)fileLocalPath, (Object)dropboxPath);
                DbxEntry.File uploadedFile = this.putSingleFile(file, dropboxPath, mode);
                if (uploadedFile == null) {
                    resultMap.put(dropboxPath, DropboxResultCode.KO);
                } else {
                    resultMap.put(dropboxPath, DropboxResultCode.OK);
                }
            }
            catch (Exception ex) {
                resultMap.put(dropboxPath, DropboxResultCode.KO);
            }
            dropboxPath = oldDropboxPath;
        }
        return new DropboxFileUploadResult(resultMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DbxEntry.File putSingleFile(File inputFile, String dropboxPath, DropboxUploadMode mode) throws Exception {
        try (FileInputStream inputStream = new FileInputStream(inputFile);){
            DbxEntry.File uploadedFile;
            DbxWriteMode uploadMode = mode == DropboxUploadMode.force ? DbxWriteMode.force() : DbxWriteMode.add();
            DbxEntry.File file = uploadedFile = this.client.uploadFile(dropboxPath, uploadMode, inputFile.length(), (InputStream)inputStream);
            return file;
        }
    }

    public DropboxSearchResult search(String remotePath, String query) throws DropboxException {
        if (query == null) {
            LOG.debug("Search no query");
            try {
                DbxEntry.WithChildren listing = this.client.getMetadataWithChildren(remotePath);
                return new DropboxSearchResult(listing.children);
            }
            catch (DbxException e) {
                throw new DropboxException(remotePath + " does not exist or can't obtain metadata");
            }
        }
        LOG.debug("Search by query: {}", (Object)query);
        try {
            List entries = this.client.searchFileAndFolderNames(remotePath, query);
            return new DropboxSearchResult(entries);
        }
        catch (DbxException e) {
            throw new DropboxException(remotePath + " does not exist or can't obtain metadata");
        }
    }

    public DropboxDelResult del(String remotePath) throws DropboxException {
        try {
            this.client.delete(remotePath);
        }
        catch (DbxException e) {
            throw new DropboxException(remotePath + " does not exist or can't obtain metadata");
        }
        return new DropboxDelResult(remotePath);
    }

    public DropboxMoveResult move(String remotePath, String newRemotePath) throws DropboxException {
        try {
            this.client.move(remotePath, newRemotePath);
            return new DropboxMoveResult(remotePath, newRemotePath);
        }
        catch (DbxException e) {
            throw new DropboxException(remotePath + " does not exist or can't obtain metadata");
        }
    }

    public DropboxFileDownloadResult get(String remotePath) throws DropboxException {
        return new DropboxFileDownloadResult(this.downloadFilesInFolder(remotePath));
    }

    public boolean isDirectory(String path) throws DropboxException {
        try {
            DbxEntry.WithChildren listing = this.client.getMetadataWithChildren(path);
            return listing.children != null;
        }
        catch (DbxException e) {
            throw new DropboxException(path + " does not exist or can't obtain metadata");
        }
    }

    private Map<String, Object> downloadFilesInFolder(String path) throws DropboxException {
        try {
            DbxEntry.WithChildren listing = this.client.getMetadataWithChildren(path);
            if (listing == null) {
                return Collections.emptyMap();
            }
            if (listing.children == null) {
                LOG.debug("downloading a single file...");
                Map.Entry<String, Object> entry = this.downloadSingleFile(path);
                return Collections.singletonMap(entry.getKey(), entry.getValue());
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (DbxEntry entry : listing.children) {
                if (entry.isFile()) {
                    try {
                        Map.Entry<String, Object> singleFile = this.downloadSingleFile(entry.path);
                        result.put(singleFile.getKey(), singleFile.getValue());
                    }
                    catch (DropboxException e) {
                        LOG.warn("Cannot download from path={}, reason={}. This exception is ignored.", (Object)entry.path, (Object)e.getMessage());
                    }
                    continue;
                }
                Map<String, Object> filesInFolder = this.downloadFilesInFolder(entry.path);
                result.putAll(filesInFolder);
            }
            return result;
        }
        catch (DbxException e) {
            throw new DropboxException(e);
        }
    }

    private Map.Entry<String, Object> downloadSingleFile(String path) throws DropboxException {
        try {
            OutputStreamBuilder target = OutputStreamBuilder.withExchange((Exchange)this.exchange);
            DbxEntry.File downloadedFile = this.client.getFile(path, null, (OutputStream)target);
            if (downloadedFile != null) {
                LOG.debug("downloaded path={}", (Object)path);
                return new AbstractMap.SimpleEntry<String, Object>(path, target.build());
            }
            return null;
        }
        catch (DbxException e) {
            throw new DropboxException(path + " does not exist or can't obtain metadata");
        }
        catch (IOException e) {
            throw new DropboxException(path + " can't obtain a stream");
        }
    }
}

