/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.StreamInputReader;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.tasks.Task;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class StreamInput
extends InputStream {
    private Version version = Version.CURRENT;
    private final CharsRef spare = new CharsRef();

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public abstract byte readByte() throws IOException;

    public abstract void readBytes(byte[] var1, int var2, int var3) throws IOException;

    public BytesReference readBytesReference() throws IOException {
        int length = this.readVInt();
        return this.readBytesReference(length);
    }

    public BytesReference readBytesReference(int length) throws IOException {
        if (length == 0) {
            return BytesArray.EMPTY;
        }
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return new BytesArray(bytes, 0, length);
    }

    public BytesRef readBytesRef() throws IOException {
        int length = this.readVInt();
        return this.readBytesRef(length);
    }

    public BytesRef readBytesRef(int length) throws IOException {
        if (length == 0) {
            return new BytesRef();
        }
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return new BytesRef(bytes, 0, length);
    }

    public void readFully(byte[] b) throws IOException {
        this.readBytes(b, 0, b.length);
    }

    public short readShort() throws IOException {
        return (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
    }

    public int readInt() throws IOException {
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public int readVInt() throws IOException {
        byte b = this.readByte();
        int i = b & 0x7F;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 7;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 14;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 21;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        assert ((b & 0x80) == 0);
        return i | (b & 0x7F) << 28;
    }

    public long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readVLong() throws IOException {
        byte b = this.readByte();
        long i = (long)b & 0x7FL;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 7;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 14;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 21;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 28;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 35;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 42;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 49;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        assert ((b & 0x80) == 0);
        return i | ((long)b & 0x7FL) << 56;
    }

    @Nullable
    public Text readOptionalText() throws IOException {
        int length = this.readInt();
        if (length == -1) {
            return null;
        }
        return new Text(this.readBytesReference(length));
    }

    public Text readText() throws IOException {
        int length = this.readInt();
        return new Text(this.readBytesReference(length));
    }

    @Nullable
    public String readOptionalString() throws IOException {
        if (this.readBoolean()) {
            return this.readString();
        }
        return null;
    }

    @Nullable
    public Integer readOptionalVInt() throws IOException {
        if (this.readBoolean()) {
            return this.readVInt();
        }
        return null;
    }

    public String readString() throws IOException {
        int charCount = this.readVInt();
        if (this.spare.chars.length < charCount) {
            this.spare.chars = new char[ArrayUtil.oversize((int)charCount, (int)2)];
        }
        this.spare.length = charCount;
        char[] buffer = this.spare.chars;
        block5: for (int i = 0; i < charCount; ++i) {
            int c = this.readByte() & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    buffer[i] = (char)c;
                    continue block5;
                }
                case 12: 
                case 13: {
                    buffer[i] = (char)((c & 0x1F) << 6 | this.readByte() & 0x3F);
                    continue block5;
                }
                case 14: {
                    buffer[i] = (char)((c & 0xF) << 12 | (this.readByte() & 0x3F) << 6 | (this.readByte() & 0x3F) << 0);
                    continue block5;
                }
                default: {
                    new AssertionError((Object)("unexpected character: " + c + " hex: " + Integer.toHexString(c)));
                }
            }
        }
        return this.spare.toString();
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Nullable
    public final Boolean readOptionalBoolean() throws IOException {
        byte val = this.readByte();
        if (val == 2) {
            return null;
        }
        if (val == 1) {
            return true;
        }
        return false;
    }

    @Override
    public abstract void reset() throws IOException;

    @Override
    public abstract void close() throws IOException;

    @Override
    public abstract int available() throws IOException;

    public String[] readStringArray() throws IOException {
        int size = this.readVInt();
        if (size == 0) {
            return Strings.EMPTY_ARRAY;
        }
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = this.readString();
        }
        return ret;
    }

    @Nullable
    public Map<String, Object> readMap() throws IOException {
        return (Map)this.readGenericValue();
    }

    @Nullable
    public Object readGenericValue() throws IOException {
        byte type = this.readByte();
        switch (type) {
            case -1: {
                return null;
            }
            case 0: {
                return this.readString();
            }
            case 1: {
                return this.readInt();
            }
            case 2: {
                return this.readLong();
            }
            case 3: {
                return Float.valueOf(this.readFloat());
            }
            case 4: {
                return this.readDouble();
            }
            case 5: {
                return this.readBoolean();
            }
            case 6: {
                int bytesSize = this.readVInt();
                byte[] value = new byte[bytesSize];
                this.readBytes(value, 0, bytesSize);
                return value;
            }
            case 7: {
                int size = this.readVInt();
                ArrayList<Object> list = new ArrayList<Object>(size);
                for (int i = 0; i < size; ++i) {
                    list.add(this.readGenericValue());
                }
                return list;
            }
            case 8: {
                int size8 = this.readVInt();
                Object[] list8 = new Object[size8];
                for (int i = 0; i < size8; ++i) {
                    list8[i] = this.readGenericValue();
                }
                return list8;
            }
            case 9: {
                int size9 = this.readVInt();
                LinkedHashMap<String, Object> map9 = new LinkedHashMap<String, Object>(size9);
                for (int i = 0; i < size9; ++i) {
                    map9.put(this.readString(), this.readGenericValue());
                }
                return map9;
            }
            case 10: {
                int size10 = this.readVInt();
                HashMap<String, Object> map10 = new HashMap<String, Object>(size10);
                for (int i = 0; i < size10; ++i) {
                    map10.put(this.readString(), this.readGenericValue());
                }
                return map10;
            }
            case 11: {
                return this.readByte();
            }
            case 12: {
                return new Date(this.readLong());
            }
            case 13: {
                String timeZoneId = this.readString();
                return new DateTime(this.readLong(), DateTimeZone.forID((String)timeZoneId));
            }
            case 14: {
                return this.readBytesReference();
            }
            case 15: {
                return this.readText();
            }
            case 16: {
                return this.readShort();
            }
            case 17: {
                return this.readIntArray();
            }
            case 18: {
                return this.readLongArray();
            }
            case 19: {
                return this.readFloatArray();
            }
            case 20: {
                return this.readDoubleArray();
            }
            case 21: {
                return this.readBytesRef();
            }
            case 22: {
                return this.readGeoPoint();
            }
        }
        throw new IOException("Can't read unknown type [" + type + "]");
    }

    public GeoPoint readGeoPoint() throws IOException {
        return new GeoPoint(this.readDouble(), this.readDouble());
    }

    public int[] readIntArray() throws IOException {
        int length = this.readVInt();
        int[] values = new int[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readInt();
        }
        return values;
    }

    public int[] readVIntArray() throws IOException {
        int length = this.readVInt();
        int[] values = new int[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readVInt();
        }
        return values;
    }

    public long[] readLongArray() throws IOException {
        int length = this.readVInt();
        long[] values = new long[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readLong();
        }
        return values;
    }

    public long[] readVLongArray() throws IOException {
        int length = this.readVInt();
        long[] values = new long[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readVLong();
        }
        return values;
    }

    public float[] readFloatArray() throws IOException {
        int length = this.readVInt();
        float[] values = new float[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readFloat();
        }
        return values;
    }

    public double[] readDoubleArray() throws IOException {
        int length = this.readVInt();
        double[] values = new double[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readDouble();
        }
        return values;
    }

    public byte[] readByteArray() throws IOException {
        int length = this.readVInt();
        byte[] values = new byte[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readByte();
        }
        return values;
    }

    public <T extends Streamable> T readOptionalStreamable(T streamable) throws IOException {
        if (this.readBoolean()) {
            streamable.readFrom(this);
            return streamable;
        }
        return null;
    }

    public <T extends Throwable> T readThrowable() throws IOException {
        if (this.readBoolean()) {
            int key = this.readVInt();
            switch (key) {
                case 0: {
                    int ord = this.readVInt();
                    return (T)ElasticsearchException.readException(this, ord);
                }
                case 1: {
                    String msg1 = this.readOptionalString();
                    String resource1 = this.readOptionalString();
                    return (T)((Object)ElasticsearchException.readStackTrace(new CorruptIndexException(msg1, resource1, this.readThrowable()), this));
                }
                case 2: {
                    String resource2 = this.readOptionalString();
                    int version2 = this.readInt();
                    int minVersion2 = this.readInt();
                    int maxVersion2 = this.readInt();
                    return (T)((Object)ElasticsearchException.readStackTrace(new IndexFormatTooNewException(resource2, version2, minVersion2, maxVersion2), this));
                }
                case 3: {
                    String resource3 = this.readOptionalString();
                    if (this.readBoolean()) {
                        int version3 = this.readInt();
                        int minVersion3 = this.readInt();
                        int maxVersion3 = this.readInt();
                        return (T)((Object)ElasticsearchException.readStackTrace(new IndexFormatTooOldException(resource3, version3, minVersion3, maxVersion3), this));
                    }
                    String version3 = this.readOptionalString();
                    return (T)((Object)ElasticsearchException.readStackTrace(new IndexFormatTooOldException(resource3, version3), this));
                }
                case 4: {
                    return (T)ElasticsearchException.readStackTrace(new NullPointerException(this.readOptionalString()), this);
                }
                case 5: {
                    return (T)ElasticsearchException.readStackTrace(new NumberFormatException(this.readOptionalString()), this);
                }
                case 6: {
                    return (T)ElasticsearchException.readStackTrace(new IllegalArgumentException(this.readOptionalString(), (Throwable)this.readThrowable()), this);
                }
                case 7: {
                    return (T)((Object)ElasticsearchException.readStackTrace(new AlreadyClosedException(this.readOptionalString(), this.readThrowable()), this));
                }
                case 8: {
                    return (T)ElasticsearchException.readStackTrace(new EOFException(this.readOptionalString()), this);
                }
                case 9: {
                    return (T)ElasticsearchException.readStackTrace(new SecurityException(this.readOptionalString(), (Throwable)this.readThrowable()), this);
                }
                case 10: {
                    return (T)ElasticsearchException.readStackTrace(new StringIndexOutOfBoundsException(this.readOptionalString()), this);
                }
                case 11: {
                    return (T)ElasticsearchException.readStackTrace(new ArrayIndexOutOfBoundsException(this.readOptionalString()), this);
                }
                case 12: {
                    return (T)ElasticsearchException.readStackTrace(new AssertionError(this.readOptionalString(), (Throwable)this.readThrowable()), this);
                }
                case 13: {
                    return (T)ElasticsearchException.readStackTrace(new FileNotFoundException(this.readOptionalString()), this);
                }
                case 14: {
                    String file = this.readOptionalString();
                    String other = this.readOptionalString();
                    String reason = this.readOptionalString();
                    this.readOptionalString();
                    return (T)ElasticsearchException.readStackTrace(new NoSuchFileException(file, other, reason), this);
                }
                case 15: {
                    return (T)ElasticsearchException.readStackTrace(new OutOfMemoryError(this.readOptionalString()), this);
                }
                case 16: {
                    return (T)ElasticsearchException.readStackTrace(new IllegalStateException(this.readOptionalString(), (Throwable)this.readThrowable()), this);
                }
                case 17: {
                    return (T)((Object)ElasticsearchException.readStackTrace(new LockObtainFailedException(this.readOptionalString(), this.readThrowable()), this));
                }
                case 18: {
                    return (T)ElasticsearchException.readStackTrace(new InterruptedException(this.readOptionalString()), this);
                }
            }
            assert (false) : "no such exception for id: " + key;
        }
        return null;
    }

    <C> C readNamedWriteable(Class<C> categoryClass) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Task.Status readTaskStatus() throws IOException {
        return this.readNamedWriteable(Task.Status.class);
    }

    public <T> List<T> readList(StreamInputReader<T> reader) throws IOException {
        int count = this.readVInt();
        ArrayList<T> builder = new ArrayList<T>(count);
        for (int i = 0; i < count; ++i) {
            builder.add(reader.read(this));
        }
        return builder;
    }

    public static StreamInput wrap(BytesReference reference) {
        if (!reference.hasArray()) {
            reference = reference.toBytesArray();
        }
        return StreamInput.wrap(reference.array(), reference.arrayOffset(), reference.length());
    }

    public static StreamInput wrap(byte[] bytes) {
        return StreamInput.wrap(bytes, 0, bytes.length);
    }

    public static StreamInput wrap(byte[] bytes, int offset, int length) {
        return new InputStreamStreamInput(new ByteArrayInputStream(bytes, offset, length));
    }
}

