/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty;

import java.io.IOException;
import java.io.StreamCorruptedException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.rest.RestStatus;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;

public class SizeHeaderFrameDecoder
extends FrameDecoder {
    private static final long NINETY_PER_HEAP_SIZE = (long)((double)JvmInfo.jvmInfo().getMem().getHeapMax().bytes() * 0.9);

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        int sizeHeaderLength = 6;
        if (buffer.readableBytes() < 6) {
            return null;
        }
        int readerIndex = buffer.readerIndex();
        if (buffer.getByte(readerIndex) != 69 || buffer.getByte(readerIndex + 1) != 83) {
            if (this.bufferStartsWith(buffer, readerIndex, "GET ") || this.bufferStartsWith(buffer, readerIndex, "POST ") || this.bufferStartsWith(buffer, readerIndex, "PUT ") || this.bufferStartsWith(buffer, readerIndex, "HEAD ") || this.bufferStartsWith(buffer, readerIndex, "DELETE ") || this.bufferStartsWith(buffer, readerIndex, "OPTIONS ") || this.bufferStartsWith(buffer, readerIndex, "PATCH ") || this.bufferStartsWith(buffer, readerIndex, "TRACE ")) {
                throw new HttpOnTransportException("This is not a HTTP port");
            }
            throw new StreamCorruptedException("invalid internal transport message format, got (" + Integer.toHexString(buffer.getByte(readerIndex) & 0xFF) + "," + Integer.toHexString(buffer.getByte(readerIndex + 1) & 0xFF) + "," + Integer.toHexString(buffer.getByte(readerIndex + 2) & 0xFF) + "," + Integer.toHexString(buffer.getByte(readerIndex + 3) & 0xFF) + ")");
        }
        int dataLen = buffer.getInt(buffer.readerIndex() + 2);
        if (dataLen == -1) {
            buffer.skipBytes(6);
            return null;
        }
        if (dataLen <= 0) {
            throw new StreamCorruptedException("invalid data length: " + dataLen);
        }
        if ((long)dataLen > NINETY_PER_HEAP_SIZE) {
            throw new TooLongFrameException("transport content length received [" + new ByteSizeValue(dataLen) + "] exceeded [" + new ByteSizeValue(NINETY_PER_HEAP_SIZE) + "]");
        }
        if (buffer.readableBytes() < dataLen + 6) {
            return null;
        }
        buffer.skipBytes(6);
        return buffer;
    }

    private boolean bufferStartsWith(ChannelBuffer buffer, int readerIndex, String method) {
        char[] chars = method.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (buffer.getByte(readerIndex + i) == chars[i]) continue;
            return false;
        }
        return true;
    }

    public static class HttpOnTransportException
    extends ElasticsearchException {
        public HttpOnTransportException(String msg) {
            super(msg, new Object[0]);
        }

        @Override
        public RestStatus status() {
            return RestStatus.BAD_REQUEST;
        }

        public HttpOnTransportException(StreamInput in) throws IOException {
            super(in);
        }
    }
}

