/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.serialization;

import java.util.List;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.serialization.DatagramWriter;

public class DataSerializer {
    private DatagramWriter writer;

    public byte[] serializeRequest(Request request) {
        this.writer = new DatagramWriter();
        CoAP.Code code = request.getCode();
        this.serializeMessage(request, code == null ? 0 : code.value);
        return this.writer.toByteArray();
    }

    public byte[] serializeResponse(Response response) {
        this.writer = new DatagramWriter();
        this.serializeMessage(response, response.getCode().value);
        return this.writer.toByteArray();
    }

    public byte[] serializeEmptyMessage(Message message) {
        this.writer = new DatagramWriter();
        this.serializeMessage(message, 0);
        return this.writer.toByteArray();
    }

    private void serializeMessage(Message message, int code) {
        if (message.getToken() == null) {
            throw new NullPointerException("No Token has been set, not even an empty byte[0]");
        }
        this.writer.write(1, 2);
        this.writer.write(message.getType().value, 2);
        this.writer.write(message.getToken().length, 4);
        this.writer.write(code, 8);
        this.writer.write(message.getMID(), 16);
        this.writer.writeBytes(message.getToken());
        List<Option> options = message.getOptions().asSortedList();
        int lastOptionNumber = 0;
        for (Option option : options) {
            int optionDelta = option.getNumber() - lastOptionNumber;
            int optionDeltaNibble = this.getOptionNibble(optionDelta);
            this.writer.write(optionDeltaNibble, 4);
            int optionLength = option.getLength();
            int optionLengthNibble = this.getOptionNibble(optionLength);
            this.writer.write(optionLengthNibble, 4);
            if (optionDeltaNibble == 13) {
                this.writer.write(optionDelta - 13, 8);
            } else if (optionDeltaNibble == 14) {
                this.writer.write(optionDelta - 269, 16);
            }
            if (optionLengthNibble == 13) {
                this.writer.write(optionLength - 13, 8);
            } else if (optionLengthNibble == 14) {
                this.writer.write(optionLength - 269, 16);
            }
            this.writer.writeBytes(option.getValue());
            lastOptionNumber = option.getNumber();
        }
        byte[] payload = message.getPayload();
        if (payload != null && payload.length > 0) {
            this.writer.writeByte((byte)-1);
            this.writer.writeBytes(payload);
        }
    }

    private int getOptionNibble(int optionValue) {
        if (optionValue <= 12) {
            return optionValue;
        }
        if (optionValue <= 268) {
            return 13;
        }
        if (optionValue <= 65804) {
            return 14;
        }
        throw new IllegalArgumentException("Unsupported option delta " + optionValue);
    }
}

