/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Properties;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceWriter;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.json.JsonReceiver;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.serialize.CharacterMap;
import net.sf.saxon.serialize.ExpandedStreamResult;
import net.sf.saxon.serialize.charcode.CharacterSet;
import net.sf.saxon.serialize.codenorm.Normalizer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.z.IntPredicate;

public class JSONEmitter
extends SequenceWriter {
    private ExpandedStreamResult result;
    private boolean allowDuplicateKeys = false;
    private String nodeOutputMethod = "xml";
    private int count = 0;
    private Writer writer;
    private Normalizer normalizer;
    private CharacterMap characterMap;
    private Properties outputProperties;
    private CharacterSet characterSet;
    private boolean indent;
    private boolean unfailing = false;

    public JSONEmitter(PipelineConfiguration pipe, StreamResult result, Properties outputProperties) throws XPathException {
        super(pipe);
        this.setOutputProperties(outputProperties);
        this.result = new ExpandedStreamResult(pipe.getConfiguration(), result, outputProperties);
    }

    public void setOutputProperties(Properties details) throws XPathException {
        String jnom;
        this.outputProperties = details;
        if ("yes".equals(details.getProperty("allow-duplicate-names"))) {
            this.allowDuplicateKeys = true;
        }
        if ("yes".equals(details.getProperty("indent"))) {
            this.indent = true;
        }
        if ("yes".equals(details.getProperty("{http://saxon.sf.net/}unfailing"))) {
            this.unfailing = true;
            this.allowDuplicateKeys = true;
        }
        if ((jnom = details.getProperty("json-node-output-method")) != null) {
            this.nodeOutputMethod = jnom;
        }
    }

    public Properties getOutputProperties() {
        return this.outputProperties;
    }

    public void setNormalizer(Normalizer normalizer) {
        this.normalizer = normalizer;
    }

    public void setCharacterMap(CharacterMap map) {
        this.characterMap = map;
    }

    public void write(Item item) throws XPathException {
        if (this.count++ > 0 && !this.unfailing) {
            throw new XPathException("JSON output method cannot handle a sequence of more than one item", "SERE0023");
        }
        this.writeItem(item, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeItem(Item item, int level) throws XPathException {
        try {
            if (item instanceof NumericValue) {
                if (((NumericValue)item).isNaN()) {
                    if (!this.unfailing) throw new XPathException("JSON has no way of representing NaN", "SERE0020");
                    this.emit("NaN");
                    return;
                } else if (Double.isInfinite(((NumericValue)item).getDoubleValue())) {
                    if (!this.unfailing) throw new XPathException("JSON has no way of representing Infinity", "SERE0020");
                    this.emit(((NumericValue)item).getDoubleValue() < 0.0 ? "-INF" : "INF");
                    return;
                } else {
                    this.emit(item.getStringValue());
                }
                return;
            } else if (item instanceof BooleanValue) {
                this.emit(item.getStringValue());
                return;
            } else if (item instanceof AtomicValue) {
                this.emit('\"');
                this.emit(this.escape(item.getStringValue()));
                this.emit('\"');
                return;
            } else if (item instanceof MapItem) {
                HashSet<String> keys = null;
                if (!this.allowDuplicateKeys) {
                    keys = new HashSet<String>();
                }
                this.emitOpen('{', level);
                boolean first = true;
                for (KeyValuePair pair : (MapItem)item) {
                    if (first) {
                        first = false;
                    } else {
                        this.emitComma(level);
                    }
                    this.emit('\"');
                    String stringKey = pair.key.getStringValue();
                    if (!this.allowDuplicateKeys && !keys.add(stringKey)) {
                        throw new XPathException("Key value \"" + stringKey + "\" occurs more than once in JSON map", "SERE0022");
                    }
                    this.emit(this.escape(stringKey));
                    this.emit('\"');
                    this.emit(':');
                    this.writeSequence(SequenceTool.toGroundedValue(pair.value), level + 1);
                }
                this.emitClose('}', level);
                return;
            } else if (item instanceof ArrayItem) {
                this.emitOpen('[', level);
                boolean first = true;
                for (Sequence member : (ArrayItem)item) {
                    if (first) {
                        first = false;
                    } else {
                        this.emitComma(level);
                    }
                    this.writeSequence(SequenceTool.toGroundedValue(member), level + 1);
                }
                this.emitClose(']', level);
                return;
            } else {
                if (!(item instanceof NodeInfo)) throw new XPathException("JSON output method cannot handle an item of type " + item.getClass(), "SERE0021");
                this.emit('\"');
                String s = this.serializeNode((NodeInfo)item);
                this.emit(this.escape(s));
                this.emit('\"');
            }
            return;
        }
        catch (IOException err) {
            throw new XPathException("Failure writing to " + this.getSystemId(), err);
        }
    }

    private void emitOpen(char bracket, int level) throws XPathException {
        if (this.indent) {
            this.emit(' ');
        }
        this.emit(bracket);
        if (this.indent) {
            this.emit('\n');
            for (int i = 0; i < 2 * (level + 1); ++i) {
                this.emit(' ');
            }
        }
    }

    private void emitClose(char bracket, int level) throws XPathException {
        if (this.indent) {
            this.emit('\n');
            for (int i = 0; i <= 2 * level; ++i) {
                this.emit(' ');
            }
        }
        this.emit(bracket);
    }

    private void emitComma(int level) throws XPathException {
        this.emit(',');
        if (this.indent) {
            this.emit('\n');
            for (int i = 0; i < 2 * (level + 1); ++i) {
                this.emit(' ');
            }
        }
    }

    private CharSequence escape(String s) throws XPathException {
        CharSequence cs = JsonReceiver.escape(s, false, new IntPredicate(){

            public boolean matches(int c) {
                return c < 31 || c >= 127 && c <= 159 || !JSONEmitter.this.characterSet.inCharset(c);
            }
        });
        if (this.normalizer != null) {
            cs = this.normalizer.normalize(cs);
        }
        if (this.characterMap != null) {
            cs = this.characterMap.map(cs, false);
        }
        return cs;
    }

    private String serializeNode(NodeInfo node) throws XPathException {
        StringWriter sw = new StringWriter();
        Properties props = new Properties();
        props.setProperty("method", this.nodeOutputMethod);
        props.setProperty("indent", "no");
        props.setProperty("omit-xml-declaration", "yes");
        QueryResult.serialize(node, new StreamResult(sw), props);
        return sw.toString().trim();
    }

    private void emit(CharSequence s) throws XPathException {
        if (this.writer == null) {
            this.writer = this.result.obtainWriter();
            this.characterSet = this.result.getCharacterSet();
        }
        try {
            this.writer.append(s);
        }
        catch (IOException e) {
            throw new XPathException(e);
        }
    }

    private void emit(char c) throws XPathException {
        this.emit(c + "");
    }

    private void writeSequence(GroundedValue seq, int level) throws XPathException, IOException {
        int len = seq.getLength();
        if (len == 0) {
            this.emit("null");
        } else if (len == 1) {
            this.writeItem(seq.head(), level);
        } else {
            throw new XPathException("JSON serialization: cannot handle a sequence of length " + len, "SERE0023");
        }
    }

    public void close() throws XPathException {
        if (this.count == 0) {
            this.emit("null");
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.close();
    }
}

