/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.repository.support;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.naming.Name;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Persistable;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.core.NameClassPairCallbackHandler;
import org.springframework.ldap.core.support.CountNameClassPairCallbackHandler;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.odm.core.ObjectDirectoryMapper;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.ldap.repository.LdapRepository;
import org.springframework.util.Assert;

public class SimpleLdapRepository<T>
implements LdapRepository<T> {
    private static final String OBJECTCLASS_ATTRIBUTE = "objectclass";
    private final LdapOperations ldapOperations;
    private final ObjectDirectoryMapper odm;
    private final Class<T> clazz;

    public SimpleLdapRepository(LdapOperations ldapOperations, ObjectDirectoryMapper odm, Class<T> clazz) {
        this.ldapOperations = ldapOperations;
        this.odm = odm;
        this.clazz = clazz;
    }

    protected LdapOperations getLdapOperations() {
        return this.ldapOperations;
    }

    protected Class<T> getClazz() {
        return this.clazz;
    }

    public long count() {
        Filter filter = this.odm.filterFor(this.clazz, null);
        CountNameClassPairCallbackHandler callback = new CountNameClassPairCallbackHandler();
        LdapQuery query = LdapQueryBuilder.query().attributes(OBJECTCLASS_ATTRIBUTE).filter(filter);
        this.ldapOperations.search(query, (NameClassPairCallbackHandler)callback);
        return callback.getNoOfRows();
    }

    private <S extends T> boolean isNew(S entity, Name id) {
        if (entity instanceof Persistable) {
            Persistable persistable = (Persistable)entity;
            return persistable.isNew();
        }
        return id == null;
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null");
        Name declaredId = this.odm.getId(entity);
        if (this.isNew(entity, declaredId)) {
            this.ldapOperations.create(entity);
        } else {
            this.ldapOperations.update(entity);
        }
        return entity;
    }

    public <S extends T> Iterable<S> save(Iterable<S> entities) {
        return new TransformingIterable(entities, new Function<S, S>(){

            @Override
            public S transform(S entry) {
                return SimpleLdapRepository.this.save(entry);
            }
        });
    }

    public T findOne(Name name) {
        Assert.notNull((Object)name, (String)"Id must not be null");
        try {
            return this.ldapOperations.findByDn(name, this.clazz);
        }
        catch (NameNotFoundException e) {
            return null;
        }
    }

    @Override
    public List<T> findAll(LdapQuery ldapQuery) {
        Assert.notNull((Object)ldapQuery, (String)"LdapQuery must not be null");
        return this.ldapOperations.find(ldapQuery, this.clazz);
    }

    @Override
    public T findOne(LdapQuery ldapQuery) {
        Assert.notNull((Object)ldapQuery, (String)"LdapQuery must not be null");
        try {
            return this.ldapOperations.findOne(ldapQuery, this.clazz);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public boolean exists(Name name) {
        Assert.notNull((Object)name, (String)"Id must not be null");
        return this.findOne(name) != null;
    }

    public List<T> findAll() {
        return this.ldapOperations.findAll(this.clazz);
    }

    public List<T> findAll(Iterable<Name> names) {
        TransformingIterable found = new TransformingIterable(names, new Function<Name, T>(){

            @Override
            public T transform(Name name) {
                return SimpleLdapRepository.this.findOne(name);
            }
        });
        LinkedList list = new LinkedList();
        for (Object entry : found) {
            if (entry == null) continue;
            list.add(entry);
        }
        return list;
    }

    public void delete(Name name) {
        Assert.notNull((Object)name, (String)"Id must not be null");
        this.ldapOperations.unbind(name);
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"Entity must not be null");
        this.ldapOperations.delete(entity);
    }

    public void delete(Iterable<? extends T> entities) {
        for (T entity : entities) {
            this.delete(entity);
        }
    }

    public void deleteAll() {
        this.delete(this.findAll());
    }

    private static interface Function<F, T> {
        public T transform(F var1);
    }

    private static final class TransformingIterable<F, T>
    implements Iterable<T> {
        private final Iterable<F> target;
        private final Function<F, T> function;

        private TransformingIterable(Iterable<F> target, Function<F, T> function) {
            this.target = target;
            this.function = function;
        }

        @Override
        public Iterator<T> iterator() {
            final Iterator<F> targetIterator = this.target.iterator();
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return targetIterator.hasNext();
                }

                @Override
                public T next() {
                    return TransformingIterable.this.function.transform(targetIterator.next());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Remove is not supported for this iterator");
                }
            };
        }
    }
}

