/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.elsql;

import com.opengamma.elsql.SqlFragments;
import com.opengamma.elsql.SqlParams;

abstract class SqlFragment {
    SqlFragment() {
    }

    abstract void toSQL(StringBuilder var1, SqlFragments var2, SqlParams var3, int[] var4);

    String applyLoopIndex(String text, int[] loopIndex) {
        String result = text;
        switch (loopIndex.length) {
            case 4: {
                result = result.replace("@LOOPINDEX3", Integer.toString(loopIndex[3]));
            }
            case 3: {
                result = result.replace("@LOOPINDEX2", Integer.toString(loopIndex[2]));
            }
            case 2: {
                result = result.replace("@LOOPINDEX1", Integer.toString(loopIndex[1]));
            }
        }
        result = result.replace("@LOOPINDEX", Integer.toString(loopIndex[loopIndex.length - 1]));
        return result;
    }

    static String extractVariableName(String variable) {
        if (variable == null || !variable.startsWith(":") || variable.length() < 2) {
            throw new IllegalArgumentException("Argument is not a variable (starting with a colon)");
        }
        String postColon = variable.substring(1);
        if (postColon.startsWith("{") && postColon.endsWith("}")) {
            return postColon.substring(1, postColon.length() - 1);
        }
        return postColon;
    }

    static int extractVariableOrLiteral(SqlParams params, String str) {
        if (str != null) {
            if (str.startsWith(":") && str.length() > 1) {
                String fetchVariableName = SqlFragment.extractVariableName(str);
                if (params.contains(fetchVariableName)) {
                    return ((Number)params.get(fetchVariableName)).intValue();
                }
            } else if (str.matches("[0-9]+")) {
                return Integer.parseInt(str);
            }
        }
        return 0;
    }
}

