/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin.DependencyLink;
import zipkin.Span;
import zipkin.internal.DependencyLinkSpan;
import zipkin.internal.MergeById;
import zipkin.internal.Node;
import zipkin.internal.Pair;

public final class DependencyLinker {
    private static final Logger logger = Logger.getLogger(DependencyLinker.class.getName());
    private final Map<Pair<String>, Long> linkMap = new LinkedHashMap<Pair<String>, Long>();

    public DependencyLinker putTrace(Collection<Span> spans) {
        if (spans.isEmpty()) {
            return this;
        }
        LinkedList<DependencyLinkSpan> linkSpans = new LinkedList<DependencyLinkSpan>();
        for (Span s : MergeById.apply(spans)) {
            linkSpans.add(DependencyLinkSpan.from(s));
        }
        return this.putTrace(linkSpans.iterator());
    }

    public DependencyLinker putTrace(Iterator<DependencyLinkSpan> spans) {
        if (!spans.hasNext()) {
            return this;
        }
        Node.TreeBuilder<DependencyLinkSpan> builder = new Node.TreeBuilder<DependencyLinkSpan>();
        while (spans.hasNext()) {
            DependencyLinkSpan next = spans.next();
            builder.addNode(next.parentId, next.id, next);
        }
        Node tree = builder.build();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("traversing trace tree, breadth-first");
        }
        Iterator i = tree.traverse();
        block5: while (i.hasNext()) {
            Pair<String> key;
            String parent;
            String child;
            Node current = i.next();
            DependencyLinkSpan currentSpan = (DependencyLinkSpan)current.value();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("processing " + currentSpan);
            }
            if (current.isSyntheticRootForPartialTree()) {
                logger.fine("skipping synthetic node for broken span tree");
                continue;
            }
            switch (currentSpan.kind) {
                case SERVER: {
                    child = currentSpan.service;
                    parent = currentSpan.peerService;
                    if (current != tree || parent != null) break;
                    logger.fine("root's peer is unknown; skipping");
                    continue block5;
                }
                case CLIENT: {
                    child = currentSpan.peerService;
                    parent = currentSpan.service;
                    break;
                }
                default: {
                    logger.fine("non-rpc span; skipping");
                    continue block5;
                }
            }
            if (logger.isLoggable(Level.FINE) && parent == null) {
                logger.fine("cannot determine parent, looking for first server ancestor");
            }
            for (Node ancestor = current.parent(); ancestor != null && parent == null; ancestor = ancestor.parent()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("processing ancestor " + ancestor.value());
                }
                DependencyLinkSpan ancestorLink = (DependencyLinkSpan)ancestor.value();
                if (ancestor.isSyntheticRootForPartialTree() || ancestorLink.kind != DependencyLinkSpan.Kind.SERVER) continue;
                parent = ancestorLink.service;
                break;
            }
            if (parent == null || child == null) {
                logger.fine("cannot find server ancestor; skipping");
                continue;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("incrementing link " + parent + " -> " + child);
            }
            if (this.linkMap.containsKey(key = Pair.create(parent, child))) {
                this.linkMap.put(key, this.linkMap.get(key) + 1L);
                continue;
            }
            this.linkMap.put(key, 1L);
        }
        return this;
    }

    public List<DependencyLink> link() {
        ArrayList<DependencyLink> result = new ArrayList<DependencyLink>(this.linkMap.size());
        for (Map.Entry<Pair<String>, Long> entry : this.linkMap.entrySet()) {
            result.add(DependencyLink.create((String)entry.getKey()._1, (String)entry.getKey()._2, entry.getValue()));
        }
        return result;
    }

    public static List<DependencyLink> merge(Iterable<DependencyLink> in) {
        LinkedHashMap<Pair<String>, Long> links = new LinkedHashMap<Pair<String>, Long>();
        for (DependencyLink link : in) {
            Pair<String> parentChild = Pair.create(link.parent, link.child);
            long callCount = links.containsKey(parentChild) ? (Long)links.get(parentChild) : 0L;
            links.put(parentChild, callCount += link.callCount);
        }
        ArrayList<DependencyLink> result = new ArrayList<DependencyLink>(links.size());
        for (Map.Entry link : links.entrySet()) {
            result.add(DependencyLink.create((String)((Pair)link.getKey())._1, (String)((Pair)link.getKey())._2, (Long)link.getValue()));
        }
        return result;
    }
}

