/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.splunk.AtomObject;
import com.splunk.DataModelObject;
import com.splunk.Entity;
import com.splunk.Service;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DataModel
extends Entity {
    private static final JsonParser jsonParser = new JsonParser();
    private static final Gson gson = new Gson();
    private static final String ACCELERATION_LABEL = "acceleration";
    private static final String MODEL_NAME_LABEL = "modelName";
    private static final String DISPLAY_NAME_LABEL = "displayName";
    private static final String DESCRIPTION_LABEL = "description";
    private static final String RAW_JSON_LABEL = "description";
    private String description;
    private Map<String, DataModelObject> objects;
    private boolean accelerationEnabled;
    private String earliestAcceleratedTime;
    private String accelerationCronSchedule;

    DataModel(Service service, String path) {
        super(service, path);
        this.refresh();
    }

    public boolean containsObject(String name) {
        return this.objects.containsKey(name);
    }

    public DataModelObject getObject(String name) {
        return this.objects.get(name);
    }

    public Collection<DataModelObject> getObjects() {
        return Collections.unmodifiableCollection(this.objects.values());
    }

    public String getAccelerationNamespace() {
        return this.getName();
    }

    public boolean isAccelerated() {
        return this.accelerationEnabled;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRawJson() {
        return this.getString("description");
    }

    public String getDisplayName() {
        return this.getString(DISPLAY_NAME_LABEL);
    }

    @Override
    Entity load(AtomObject value) {
        Entity result = super.load(value);
        this.parseDescription(this.getString("description"));
        this.parseAcceleration(this.getString(ACCELERATION_LABEL));
        return result;
    }

    private void parseDescription(String input) {
        this.objects = new HashMap<String, DataModelObject>();
        JsonElement rootElement = jsonParser.parse(input);
        for (Map.Entry entry : rootElement.getAsJsonObject().entrySet()) {
            if (((String)entry.getKey()).equals(MODEL_NAME_LABEL)) {
                this.content.put(MODEL_NAME_LABEL, ((JsonElement)entry.getValue()).getAsString());
                continue;
            }
            if (((String)entry.getKey()).equals(DISPLAY_NAME_LABEL)) {
                this.content.put(DISPLAY_NAME_LABEL, ((JsonElement)entry.getValue()).getAsString());
                continue;
            }
            if (((String)entry.getKey()).equals("description")) {
                this.description = ((JsonElement)entry.getValue()).getAsString();
                continue;
            }
            if (!((String)entry.getKey()).equals("objects")) continue;
            JsonArray objectArray = ((JsonElement)entry.getValue()).getAsJsonArray();
            for (JsonElement object : objectArray) {
                DataModelObject dmo = DataModelObject.parse(this, object);
                this.objects.put(dmo.getName(), dmo);
            }
        }
    }

    private void parseAcceleration(String input) {
        JsonElement rootElement = jsonParser.parse(input);
        for (Map.Entry entry : rootElement.getAsJsonObject().entrySet()) {
            if (((String)entry.getKey()).equals("enabled")) {
                if (((JsonPrimitive)entry.getValue()).isBoolean()) {
                    this.accelerationEnabled = ((JsonElement)entry.getValue()).getAsBoolean();
                    continue;
                }
                if (((JsonPrimitive)entry.getValue()).isNumber()) {
                    this.accelerationEnabled = ((JsonElement)entry.getValue()).getAsInt() != 0;
                    continue;
                }
                throw new RuntimeException("splunkd returned an unknown value " + ((JsonElement)entry.getValue()).toString() + " for whether acceleration is enabled.");
            }
            if (((String)entry.getKey()).equals("earliest_time")) {
                this.earliestAcceleratedTime = ((JsonElement)entry.getValue()).getAsString();
                continue;
            }
            if (!((String)entry.getKey()).equals("cron_schedule")) continue;
            this.accelerationCronSchedule = ((JsonElement)entry.getValue()).getAsString();
        }
    }

    public void setAcceleration(boolean enabled) {
        this.accelerationEnabled = enabled;
        this.toUpdate.put("enabled", enabled);
    }

    public String getEarliestAcceleratedTime() {
        return this.earliestAcceleratedTime;
    }

    public void setEarliestAcceleratedTime(String earliestAcceleratedTime) {
        this.earliestAcceleratedTime = earliestAcceleratedTime;
        this.toUpdate.put("earliest_time", earliestAcceleratedTime);
    }

    public String getAccelerationCronSchedule() {
        return this.accelerationCronSchedule;
    }

    public void setAccelerationCronSchedule(String accelerationCronSchedule) {
        this.accelerationCronSchedule = accelerationCronSchedule;
        this.toUpdate.put("cron_schedule", accelerationCronSchedule);
    }

    @Override
    public void update() {
        HashMap accelerationMap = new HashMap();
        for (String key : new String[]{"enabled", "earliest_time", "cron_schedule"}) {
            if (!this.toUpdate.containsKey(key)) continue;
            accelerationMap.put(key, this.toUpdate.get(key));
            this.toUpdate.remove(key);
        }
        if (!accelerationMap.isEmpty()) {
            this.toUpdate.put(ACCELERATION_LABEL, gson.toJson(accelerationMap));
        }
        super.update();
    }
}

