/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.Args;
import com.splunk.Entity;
import com.splunk.Service;

public class DistributedConfiguration
extends Entity {
    DistributedConfiguration(Service service) {
        super(service, "search/distributed/config");
    }

    @Override
    protected String actionPath(String action) {
        if (action.equals("edit")) {
            return this.path + "/distributedSearch";
        }
        return super.actionPath(action);
    }

    @Override
    public void disable() {
        Args args = new Args();
        args.put("disabled", "1");
        this.update(args);
    }

    @Override
    public void enable() {
        Args args = new Args();
        args.put("disabled", "0");
        this.update(args);
    }

    public String getBlacklistNames() {
        return this.getString("blacklistNames", null);
    }

    public String getBlacklistUrls() {
        return this.getString("blacklistURLs", null);
    }

    public int getConnectionTimeout() {
        return this.getInteger("connectionTimeout", -1);
    }

    public int getCheckTimedOutServersFrequency() {
        return this.getInteger("checkTimedOutServersFrequency", 60);
    }

    public int getReceiveTimeout() {
        return this.getInteger("receiveTimeout", -1);
    }

    public boolean getRemovedTimedOutServers() {
        return this.getBoolean("removedTimedOutServers", false);
    }

    public int getSendTimeout() {
        return this.getInteger("sendTimeout", -1);
    }

    public String getServers() {
        return this.getString("servers", null);
    }

    public boolean getShareBundles() {
        return this.getBoolean("shareBundles", true);
    }

    public int getStatusTimeout() {
        return this.getInteger("statusTimeout", 10);
    }

    public boolean isDistSearchEnabled() {
        return this.getBoolean("dist_search_enabled", true);
    }

    public void setBlacklistNames(String names) {
        this.setCacheValue("blacklistNames", names);
    }

    public void setBlacklistURLs(String names) {
        this.setCacheValue("blacklistURLs", names);
    }

    public void setCheckTimedOutServersFrequency(int frequency) {
        this.setCacheValue("checkTimedOutServersFrequency", frequency);
    }

    public void setConnectionTimeout(int seconds) {
        this.setCacheValue("connectionTimeout", seconds);
    }

    public void setDisabled(boolean disabled) {
        this.setCacheValue("disabled", disabled);
    }

    public void setReceiveTimeout(int seconds) {
        this.setCacheValue("receiveTimeout", seconds);
    }

    public void setRemoveTimedOutServers(boolean removeTimedOutServers) {
        this.setCacheValue("removedTimedOutServers", removeTimedOutServers);
    }

    public void setSendTimeout(int seconds) {
        this.setCacheValue("sendTimeout", seconds);
    }

    public void setServers(String servers) {
        this.setCacheValue("servers", servers);
    }

    public void setShareBundles(boolean shareBundles) {
        this.setCacheValue("shareBundles", shareBundles);
    }

    public void setStatusTimeout(int seconds) {
        this.setCacheValue("statusTimeout", seconds);
    }
}

