/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi.transaction;

import javax.annotation.Resource;
import javax.transaction.TransactionManager;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.cdi.transaction.JtaTransactionErrorHandler;
import org.apache.camel.cdi.transaction.JtaTransactionErrorHandlerBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.TransactedPolicy;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JtaTransactionPolicy
implements TransactedPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(JtaTransactionPolicy.class);
    @Resource(lookup="java:/TransactionManager")
    protected TransactionManager transactionManager;

    public void beforeWrap(RouteContext routeContext, ProcessorDefinition<?> definition) {
        definition.setInheritErrorHandler(Boolean.valueOf(false));
    }

    public abstract void run(Runnable var1) throws Throwable;

    public Processor wrap(RouteContext routeContext, Processor processor) {
        JtaTransactionErrorHandlerBuilder txBuilder;
        ErrorHandlerBuilderRef builderRef;
        String ref;
        ErrorHandlerBuilder builder = (ErrorHandlerBuilder)routeContext.getRoute().getErrorHandlerBuilder();
        if (builder instanceof ErrorHandlerBuilderRef && ErrorHandlerBuilderRef.isErrorHandlerBuilderConfigured((String)(ref = (builderRef = (ErrorHandlerBuilderRef)builder).getRef()))) {
            LOG.debug("Looking up ErrorHandlerBuilder with ref: {}", (Object)ref);
            builder = (ErrorHandlerBuilder)ErrorHandlerBuilderRef.lookupErrorHandlerBuilder((RouteContext)routeContext, (String)ref);
        }
        if (builder != null && builder.supportTransacted()) {
            if (!(builder instanceof JtaTransactionErrorHandlerBuilder)) {
                throw new RuntimeCamelException("The given transactional error handler builder '" + builder + "' is not of type '" + JtaTransactionErrorHandlerBuilder.class.getName() + "' which is required in this environment!");
            }
            LOG.debug("The ErrorHandlerBuilder configured is a JtaTransactionErrorHandlerBuilder: {}", (Object)builder);
            txBuilder = (JtaTransactionErrorHandlerBuilder)builder.cloneBuilder();
        } else {
            LOG.debug("No or no transactional ErrorHandlerBuilder configured, will use default JtaTransactionErrorHandlerBuilder settings");
            txBuilder = new JtaTransactionErrorHandlerBuilder();
        }
        txBuilder.setTransactionPolicy(this);
        if (builder != null) {
            txBuilder.setErrorHandlers(routeContext, builder.getErrorHandlers(routeContext));
        }
        JtaTransactionErrorHandler answer = this.createTransactionErrorHandler(routeContext, processor, (ErrorHandlerBuilder)txBuilder);
        answer.setExceptionPolicy(txBuilder.getExceptionPolicyStrategy());
        txBuilder.configure(routeContext, (ErrorHandler)answer);
        routeContext.getRoute().setErrorHandlerBuilder((ErrorHandlerFactory)txBuilder);
        return answer;
    }

    protected JtaTransactionErrorHandler createTransactionErrorHandler(RouteContext routeContext, Processor processor, ErrorHandlerBuilder builder) {
        JtaTransactionErrorHandler answer;
        try {
            answer = (JtaTransactionErrorHandler)builder.createErrorHandler(routeContext, processor);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        return answer;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public static interface Runnable {
        public void run() throws Throwable;
    }
}

