/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.braintree;

import com.braintreegateway.BraintreeGateway;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.braintree.BraintreeComponent;
import org.apache.camel.component.braintree.BraintreeConfiguration;
import org.apache.camel.component.braintree.BraintreeConsumer;
import org.apache.camel.component.braintree.BraintreeProducer;
import org.apache.camel.component.braintree.internal.BraintreeApiCollection;
import org.apache.camel.component.braintree.internal.BraintreeApiName;
import org.apache.camel.component.braintree.internal.BraintreePropertiesHelper;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.component.AbstractApiEndpoint;
import org.apache.camel.util.component.ApiMethod;
import org.apache.camel.util.component.ApiMethodPropertiesHelper;
import org.apache.camel.util.component.ApiName;

@UriEndpoint(firstVersion="2.17.0", scheme="braintree", title="Braintree", syntax="braintree:apiName/methodName", consumerClass=BraintreeConsumer.class, label="api,cloud,payment")
public class BraintreeEndpoint
extends AbstractApiEndpoint<BraintreeApiName, BraintreeConfiguration> {
    @UriParam
    private final BraintreeConfiguration configuration;
    private Object apiProxy;
    private final BraintreeGateway gateway;

    public BraintreeEndpoint(String uri, BraintreeComponent component, BraintreeApiName apiName, String methodName, BraintreeConfiguration configuration, BraintreeGateway gateway) {
        super(uri, (Component)component, (ApiName)apiName, methodName, BraintreeApiCollection.getCollection().getHelper(apiName), (Object)configuration);
        this.configuration = configuration;
        this.gateway = gateway;
    }

    public Producer createProducer() throws Exception {
        return new BraintreeProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        BraintreeConsumer consumer = new BraintreeConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected ApiMethodPropertiesHelper<BraintreeConfiguration> getPropertiesHelper() {
        return BraintreePropertiesHelper.getHelper();
    }

    protected String getThreadProfileName() {
        return "CamelBraintree";
    }

    protected void afterConfigureProperties() {
        try {
            Method method = this.gateway.getClass().getMethod(((BraintreeApiName)this.apiName).getName(), new Class[0]);
            if (method == null) {
                throw new IllegalArgumentException("Invalid API name " + this.apiName);
            }
            this.apiProxy = method.invoke((Object)this.gateway, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Object getApiProxy(ApiMethod method, Map<String, Object> args) {
        return this.apiProxy;
    }
}

