/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.dto;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.component.salesforce.api.TypeReferences;

@JsonDeserialize(using=LimitsDeserializer.class)
public final class Limits
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Usage UNDEFINED = new Usage(Integer.MIN_VALUE, Integer.MIN_VALUE);
    private final Map<Operation, Usage> usages;

    public Limits(Map<Operation, Usage> usages) {
        this.usages = usages;
    }

    public Usage forOperation(Operation operation) {
        return this.usages.getOrDefault((Object)operation, UNDEFINED);
    }

    public Usage getConcurrentAsyncGetReportInstances() {
        return this.forOperation(Operation.ConcurrentAsyncGetReportInstances);
    }

    public Usage getConcurrentSyncReportRuns() {
        return this.forOperation(Operation.ConcurrentSyncReportRuns);
    }

    public Usage getDailyApiRequests() {
        return this.forOperation(Operation.DailyApiRequests);
    }

    public Usage getDailyAsyncApexExecutions() {
        return this.forOperation(Operation.DailyAsyncApexExecutions);
    }

    public Usage getDailyBulkApiRequests() {
        return this.forOperation(Operation.DailyBulkApiRequests);
    }

    public Usage getDailyDurableGenericStreamingApiEvents() {
        return this.forOperation(Operation.DailyDurableGenericStreamingApiEvents);
    }

    public Usage getDailyDurableStreamingApiEvents() {
        return this.forOperation(Operation.DailyDurableStreamingApiEvents);
    }

    public Usage getDailyGenericStreamingApiEvents() {
        return this.forOperation(Operation.DailyGenericStreamingApiEvents);
    }

    public Usage getDailyStreamingApiEvents() {
        return this.forOperation(Operation.DailyStreamingApiEvents);
    }

    public Usage getDailyWorkflowEmails() {
        return this.forOperation(Operation.DailyWorkflowEmails);
    }

    public Usage getDataStorageMB() {
        return this.forOperation(Operation.DataStorageMB);
    }

    public Usage getDurableStreamingApiConcurrentClients() {
        return this.forOperation(Operation.DurableStreamingApiConcurrentClients);
    }

    public Usage getFileStorageMB() {
        return this.forOperation(Operation.FileStorageMB);
    }

    public Usage getHourlyAsyncReportRuns() {
        return this.forOperation(Operation.HourlyAsyncReportRuns);
    }

    public Usage getHourlyDashboardRefreshes() {
        return this.forOperation(Operation.HourlyDashboardRefreshes);
    }

    public Usage getHourlyDashboardResults() {
        return this.forOperation(Operation.HourlyDashboardResults);
    }

    public Usage getHourlyDashboardStatuses() {
        return this.forOperation(Operation.HourlyDashboardStatuses);
    }

    public Usage getHourlyODataCallout() {
        return this.forOperation(Operation.HourlyODataCallout);
    }

    public Usage getHourlySyncReportRuns() {
        return this.forOperation(Operation.HourlySyncReportRuns);
    }

    public Usage getHourlyTimeBasedWorkflow() {
        return this.forOperation(Operation.HourlyTimeBasedWorkflow);
    }

    public Usage getMassEmail() {
        return this.forOperation(Operation.MassEmail);
    }

    public Usage getSingleEmail() {
        return this.forOperation(Operation.SingleEmail);
    }

    public Usage getStreamingApiConcurrentClients() {
        return this.forOperation(Operation.StreamingApiConcurrentClients);
    }

    public String toString() {
        return "Limits: " + this.usages.entrySet().stream().map(e -> e.getKey() + ": " + e.getValue()).collect(Collectors.joining(", "));
    }

    public static final class Usage
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final int UNKNOWN_VAL = Integer.MIN_VALUE;
        public static final Usage UNKNOWN = new Usage(Integer.MIN_VALUE, Integer.MIN_VALUE);
        private final int max;
        private final int remaining;
        private final Map<String, Usage> perApplication = new HashMap<String, Usage>();

        @JsonCreator
        Usage(@JsonProperty(value="Max") int max, @JsonProperty(value="Remaining") int remaining) {
            this.max = max;
            this.remaining = remaining;
        }

        public Optional<Usage> forApplication(String application) {
            return Optional.ofNullable(this.perApplication.get(application));
        }

        public Set<String> getApplications() {
            return this.perApplication.keySet();
        }

        public int getMax() {
            return this.max;
        }

        public Map<String, Usage> getPerApplicationUsage() {
            return Collections.unmodifiableMap(this.perApplication);
        }

        public int getRemaining() {
            return this.remaining;
        }

        public boolean isUnknown() {
            return this.max == Integer.MIN_VALUE && this.remaining == Integer.MIN_VALUE;
        }

        public String toString() {
            if (this.max == Integer.MIN_VALUE && this.remaining == Integer.MIN_VALUE) {
                return "Undefined";
            }
            return "Max: " + this.max + ", Remaining: " + this.remaining + ", per application: " + this.perApplication;
        }

        @JsonAnySetter
        void addApplicationUsage(String application, Usage usage) {
            this.perApplication.put(application, usage);
        }
    }

    public static enum Operation {
        ConcurrentAsyncGetReportInstances,
        ConcurrentSyncReportRuns,
        DailyApiRequests,
        DailyAsyncApexExecutions,
        DailyBulkApiRequests,
        DailyDurableGenericStreamingApiEvents,
        DailyDurableStreamingApiEvents,
        DailyGenericStreamingApiEvents,
        DailyStreamingApiEvents,
        DailyWorkflowEmails,
        DataStorageMB,
        DurableStreamingApiConcurrentClients,
        FileStorageMB,
        HourlyAsyncReportRuns,
        HourlyDashboardRefreshes,
        HourlyDashboardResults,
        HourlyDashboardStatuses,
        HourlyODataCallout,
        HourlySyncReportRuns,
        HourlyTimeBasedWorkflow,
        MassEmail,
        SingleEmail,
        StreamingApiConcurrentClients;

    }

    public static final class LimitsDeserializer
    extends JsonDeserializer {
        public Object deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
            Map usages = (Map)parser.readValueAs(TypeReferences.USAGES_TYPE);
            return new Limits(usages);
        }
    }
}

