/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config.samples;

import com.netflix.config.ConcurrentMapConfiguration;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.jmx.ConfigJMXManager;
import com.netflix.config.jmx.ConfigMBean;
import com.netflix.config.samples.SampleBean;

public class SampleApplication
extends Thread {
    static ConfigMBean configMBean = null;

    public SampleApplication() {
        this.setDaemon(false);
        this.start();
    }

    @Override
    public void run() {
        try {
            while (true) {
                SampleApplication.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    public static void main(String[] stringArray) {
        new SampleApplication();
        ConcurrentMapConfiguration concurrentMapConfiguration = new ConcurrentMapConfiguration();
        concurrentMapConfiguration.setProperty("com.netflix.config.samples.sampleapp.prop1", "value1");
        concurrentMapConfiguration.setProperty("com.netflix.config.samples.SampleApp.SampleBean.name", "A Coffee Bean from Gautemala");
        DynamicPropertyFactory.initWithConfigurationSource(concurrentMapConfiguration);
        configMBean = ConfigJMXManager.registerConfigMbean(concurrentMapConfiguration);
        System.out.println("Started SampleApplication. Launch JConsole to inspect and update properties");
        System.out.println("To see how callback work, update property com.netflix.config.samples.SampleApp.SampleBean.sensitiveBeanData from BaseConfigBean in JConsole");
        SampleBean sampleBean = new SampleBean();
        System.out.println("SampleBean:" + sampleBean);
        System.out.println(sampleBean.getName());
    }
}

