/*
 * Decompiled with CFR 0.152.
 */
package facebook4j;

import facebook4j.internal.http.HttpParameter;
import facebook4j.internal.org.json.JSONArray;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuestionUpdate
implements Serializable {
    private static final long serialVersionUID = 6854301390218101794L;
    private String question;
    private List<String> options;
    private Boolean allowNewOptions;
    private Boolean published;
    private Integer scheduledPublishTime;

    public QuestionUpdate() {
    }

    public QuestionUpdate(String question) {
        this.question = question;
    }

    public String getQuestion() {
        return this.question;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public void setOptions(List<String> options) {
        this.options = options;
    }

    public QuestionUpdate options(List<String> options) {
        this.setOptions(options);
        return this;
    }

    public QuestionUpdate option(String option) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        this.options.add(option);
        return this;
    }

    public Boolean getAllowNewOptions() {
        return this.allowNewOptions;
    }

    public void setAllowNewOptions(Boolean allowNewOptions) {
        this.allowNewOptions = allowNewOptions;
    }

    public QuestionUpdate allowNewOptions(boolean allowNewOptions) {
        this.setAllowNewOptions(allowNewOptions);
        return this;
    }

    public Boolean getPublished() {
        return this.published;
    }

    public void setPublished(Boolean published) {
        this.published = published;
    }

    public QuestionUpdate published(boolean published) {
        this.setPublished(published);
        return this;
    }

    public Integer getScheduledPublishTime() {
        return this.scheduledPublishTime;
    }

    public void setScheduledPublishTime(Integer scheduledPublishTime) {
        this.scheduledPublishTime = scheduledPublishTime;
    }

    public void setScheduledPublishTime(Date scheduledPublishTime) {
        long time = scheduledPublishTime.getTime() / 1000L;
        this.setScheduledPublishTime(Long.valueOf(time).intValue());
    }

    public QuestionUpdate scheduledPublishTime(Integer scheduledPublishTime) {
        this.setScheduledPublishTime(scheduledPublishTime);
        return this;
    }

    public QuestionUpdate scheduledPublishTime(Date scheduledPublishTime) {
        long time = scheduledPublishTime.getTime() / 1000L;
        return this.scheduledPublishTime(Long.valueOf(time).intValue());
    }

    HttpParameter[] asHttpParameterArray() {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("question", this.question));
        if (this.options != null && this.options.size() != 0) {
            params.add(new HttpParameter("options", new JSONArray(this.options).toString()));
        }
        if (this.allowNewOptions != null) {
            params.add(new HttpParameter("allow_new_options", this.allowNewOptions));
        }
        if (this.published != null) {
            params.add(new HttpParameter("published", this.published));
        }
        if (this.scheduledPublishTime != null) {
            params.add(new HttpParameter("scheduled_publish_time", this.scheduledPublishTime));
        }
        return params.toArray(new HttpParameter[params.size()]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QuestionUpdate)) {
            return false;
        }
        QuestionUpdate that = (QuestionUpdate)o;
        if (this.allowNewOptions != null ? !this.allowNewOptions.equals(that.allowNewOptions) : that.allowNewOptions != null) {
            return false;
        }
        if (this.options != null ? !((Object)this.options).equals(that.options) : that.options != null) {
            return false;
        }
        if (this.published != null ? !this.published.equals(that.published) : that.published != null) {
            return false;
        }
        if (this.question != null ? !this.question.equals(that.question) : that.question != null) {
            return false;
        }
        return !(this.scheduledPublishTime != null ? !this.scheduledPublishTime.equals(that.scheduledPublishTime) : that.scheduledPublishTime != null);
    }

    public int hashCode() {
        int result = this.question != null ? this.question.hashCode() : 0;
        result = 31 * result + (this.options != null ? ((Object)this.options).hashCode() : 0);
        result = 31 * result + (this.allowNewOptions != null ? this.allowNewOptions.hashCode() : 0);
        result = 31 * result + (this.published != null ? this.published.hashCode() : 0);
        result = 31 * result + (this.scheduledPublishTime != null ? this.scheduledPublishTime.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "QuestionUpdate{question='" + this.question + '\'' + ", options=" + this.options + ", allowNewOptions=" + this.allowNewOptions + ", published=" + this.published + ", scheduledPublishTime=" + this.scheduledPublishTime + '}';
    }
}

