/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.auth;

import facebook4j.FacebookException;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;

public class DeviceCode
implements Serializable {
    private static final long serialVersionUID = -1050681649334378859L;
    private final String code;
    private final String userCode;
    private final String verificationUri;
    private final Integer expiresIn;
    private final Integer interval;

    public DeviceCode(HttpResponse res) throws FacebookException {
        JSONObject json = res.asJSONObject();
        this.code = z_F4JInternalParseUtil.getRawString("code", json);
        this.userCode = z_F4JInternalParseUtil.getRawString("user_code", json);
        this.verificationUri = z_F4JInternalParseUtil.getRawString("verification_uri", json);
        this.expiresIn = z_F4JInternalParseUtil.getInt("expires_in", json);
        this.interval = z_F4JInternalParseUtil.getInt("interval", json);
    }

    public String getCode() {
        return this.code;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public String getVerificationUri() {
        return this.verificationUri;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeviceCode)) {
            return false;
        }
        DeviceCode that = (DeviceCode)o;
        if (this.code != null ? !this.code.equals(that.code) : that.code != null) {
            return false;
        }
        if (this.expiresIn != null ? !this.expiresIn.equals(that.expiresIn) : that.expiresIn != null) {
            return false;
        }
        if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) {
            return false;
        }
        if (this.userCode != null ? !this.userCode.equals(that.userCode) : that.userCode != null) {
            return false;
        }
        return !(this.verificationUri != null ? !this.verificationUri.equals(that.verificationUri) : that.verificationUri != null);
    }

    public int hashCode() {
        int result = this.code != null ? this.code.hashCode() : 0;
        result = 31 * result + (this.userCode != null ? this.userCode.hashCode() : 0);
        result = 31 * result + (this.verificationUri != null ? this.verificationUri.hashCode() : 0);
        result = 31 * result + (this.expiresIn != null ? this.expiresIn.hashCode() : 0);
        result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DeviceCode{code='" + this.code + '\'' + ", userCode='" + this.userCode + '\'' + ", verificationUri='" + this.verificationUri + '\'' + ", expiresIn=" + this.expiresIn + ", interval=" + this.interval + '}';
    }
}

