/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.Group;
import facebook4j.GroupPrivacyType;
import facebook4j.IdNameEntity;
import facebook4j.ResponseList;
import facebook4j.Venue;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.IdNameEntityJSONImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.json.VenueJSONImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GroupJSONImpl
extends FacebookResponseImpl
implements Group,
Serializable {
    private static final long serialVersionUID = 561347972556756182L;
    private Integer version;
    private String name;
    private String id;
    private Boolean administrator;
    private Integer bookmarkOrder;
    private IdNameEntity owner;
    private String description;
    private GroupPrivacyType privacy;
    private URL icon;
    private Date updatedTime;
    private String email;
    private Venue venue;

    GroupJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    GroupJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            if (!json.isNull("version")) {
                this.version = z_F4JInternalParseUtil.getPrimitiveInt("version", json);
            }
            this.name = z_F4JInternalParseUtil.getRawString("name", json);
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            this.administrator = z_F4JInternalParseUtil.getBoolean("administrator", json);
            if (!json.isNull("bookmark_order")) {
                this.bookmarkOrder = z_F4JInternalParseUtil.getPrimitiveInt("bookmark_order", json);
            }
            if (!json.isNull("owner")) {
                this.owner = new IdNameEntityJSONImpl(json.getJSONObject("owner"));
            }
            this.description = z_F4JInternalParseUtil.getRawString("description", json);
            this.privacy = GroupPrivacyType.getInstance(z_F4JInternalParseUtil.getRawString("privacy", json));
            this.icon = z_F4JInternalParseUtil.getURL("icon", json);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", json);
            this.email = z_F4JInternalParseUtil.getRawString("email", json);
            if (!json.isNull("venue")) {
                this.venue = new VenueJSONImpl(json.getJSONObject("venue"));
            }
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Boolean isAdministrator() {
        return this.administrator;
    }

    @Override
    public Integer getBookmarkOrder() {
        return this.bookmarkOrder;
    }

    @Override
    public IdNameEntity getOwner() {
        return this.owner;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public GroupPrivacyType getPrivacy() {
        return this.privacy;
    }

    @Override
    public URL getIcon() {
        return this.icon;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public Venue getVenue() {
        return this.venue;
    }

    static ResponseList<Group> createGroupList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Group> groups = new ResponseListImpl<Group>(size, json, new Group[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject groupJSONObject = list.getJSONObject(i);
                GroupJSONImpl group = new GroupJSONImpl(groupJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(group, groupJSONObject);
                }
                groups.add(group);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(groups, list);
            }
            return groups;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupJSONImpl other = (GroupJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "GroupJSONImpl{version=" + this.version + ", name='" + this.name + '\'' + ", id='" + this.id + '\'' + ", administrator=" + this.administrator + ", bookmarkOrder=" + this.bookmarkOrder + ", owner=" + this.owner + ", description='" + this.description + '\'' + ", privacy=" + (Object)((Object)this.privacy) + ", icon=" + this.icon + ", updatedTime=" + this.updatedTime + ", email='" + this.email + '\'' + ", venue=" + this.venue + '}';
    }
}

