/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.Paging;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PagingJSONImpl<T>
implements Paging<T>,
Serializable {
    private static final long serialVersionUID = 4741821984775700187L;
    private final Class<?> jsonObjectType;
    private final Paging.Cursors cursors;
    private final URL previous;
    private final URL next;

    PagingJSONImpl(JSONObject json, Class<?> type) throws FacebookException {
        this.jsonObjectType = type;
        try {
            this.cursors = !json.isNull("cursors") ? new CursorsJSONImpl(json.getJSONObject("cursors")) : null;
            this.previous = z_F4JInternalParseUtil.getURL("previous", json);
            this.next = z_F4JInternalParseUtil.getURL("next", json);
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    @Override
    public Class<?> getJSONObjectType() {
        return this.jsonObjectType;
    }

    @Override
    public URL getPrevious() {
        return this.previous;
    }

    @Override
    public URL getNext() {
        return this.next;
    }

    @Override
    public Paging.Cursors getCursors() {
        return this.cursors;
    }

    public String toString() {
        return "PagingJSONImpl [previous=" + this.previous + ", next=" + this.next + ", jsonObjectType=" + this.jsonObjectType + "]";
    }

    private final class CursorsJSONImpl
    implements Paging.Cursors,
    Serializable {
        private static final long serialVersionUID = -4827220838408801570L;
        private final String after;
        private final String before;

        CursorsJSONImpl(JSONObject json) throws FacebookException {
            this.after = z_F4JInternalParseUtil.getRawString("after", json);
            this.before = z_F4JInternalParseUtil.getRawString("before", json);
        }

        public String getAfter() {
            return this.after;
        }

        public String getBefore() {
            return this.before;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CursorsJSONImpl)) {
                return false;
            }
            CursorsJSONImpl that = (CursorsJSONImpl)o;
            if (this.after != null ? !this.after.equals(that.after) : that.after != null) {
                return false;
            }
            return !(this.before != null ? !this.before.equals(that.before) : that.before != null);
        }

        public int hashCode() {
            int result = this.after != null ? this.after.hashCode() : 0;
            result = 31 * result + (this.before != null ? this.before.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "CursorsJSONImpl{after='" + this.after + '\'' + ", before='" + this.before + '\'' + '}';
        }
    }
}

