/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.jms.JMSException;
import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.apache.qpid.jms.util.AbstractMessageQueue;

public final class PriorityMessageQueue
extends AbstractMessageQueue {
    private static final Integer MAX_PRIORITY = 9;
    private final LinkedList<JmsInboundMessageDispatch>[] lists = new LinkedList[MAX_PRIORITY + 1];
    private int size = 0;

    public PriorityMessageQueue() {
        for (int i = 0; i <= MAX_PRIORITY; ++i) {
            this.lists[i] = new LinkedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(JmsInboundMessageDispatch envelope) {
        Object object = this.getLock();
        synchronized (object) {
            this.getList(envelope).addLast(envelope);
            ++this.size;
            this.getLock().notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueueFirst(JmsInboundMessageDispatch envelope) {
        Object object = this.getLock();
        synchronized (object) {
            this.getList(MAX_PRIORITY).addFirst(envelope);
            ++this.size;
            this.getLock().notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.size == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.getLock();
        synchronized (object) {
            return this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.getLock();
        synchronized (object) {
            for (int i = 0; i <= MAX_PRIORITY; ++i) {
                this.lists[i].clear();
            }
            this.size = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JmsInboundMessageDispatch> removeAll() {
        Object object = this.getLock();
        synchronized (object) {
            ArrayList<JmsInboundMessageDispatch> result = new ArrayList<JmsInboundMessageDispatch>(this.size());
            for (int i = MAX_PRIORITY.intValue(); i >= 0; --i) {
                LinkedList<JmsInboundMessageDispatch> list = this.lists[i];
                result.addAll(list);
                this.size -= list.size();
                list.clear();
            }
            return result;
        }
    }

    @Override
    protected JmsInboundMessageDispatch removeFirst() {
        if (this.size > 0) {
            for (int i = MAX_PRIORITY.intValue(); i >= 0; --i) {
                LinkedList<JmsInboundMessageDispatch> list = this.lists[i];
                if (list.isEmpty()) continue;
                --this.size;
                return list.removeFirst();
            }
        }
        return null;
    }

    @Override
    protected JmsInboundMessageDispatch peekFirst() {
        if (this.size > 0) {
            for (int i = MAX_PRIORITY.intValue(); i >= 0; --i) {
                LinkedList<JmsInboundMessageDispatch> list = this.lists[i];
                if (list.isEmpty()) continue;
                return list.peekFirst();
            }
        }
        return null;
    }

    private int getPriority(JmsInboundMessageDispatch envelope) {
        int priority = 4;
        if (envelope.getMessage() != null) {
            try {
                priority = Math.max(envelope.getMessage().getJMSPriority(), 0);
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            priority = Math.min(priority, MAX_PRIORITY);
        }
        return priority;
    }

    private LinkedList<JmsInboundMessageDispatch> getList(JmsInboundMessageDispatch envelope) {
        return this.getList(this.getPriority(envelope));
    }

    private LinkedList<JmsInboundMessageDispatch> getList(int priority) {
        return this.lists[priority];
    }
}

