/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb.converters;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.util.Map;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.FallbackConverter;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.spi.TypeConverterRegistry;

@Converter
public final class MongoDbFallbackConverter {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private MongoDbFallbackConverter() {
    }

    @FallbackConverter
    public static Object convertTo(Class<?> type, Exchange exchange, Object value, TypeConverterRegistry registry) throws InvalidPayloadException {
        if (String.class == value.getClass()) {
            if (type == DBObject.class) {
                Object out = JSON.parse((String)value.toString());
                if (out instanceof DBObject) {
                    return out;
                }
                throw new InvalidPayloadException(exchange, type);
            }
            if (type == BasicDBList.class) {
                Object out = JSON.parse((String)value.toString());
                if (out instanceof BasicDBList) {
                    return out;
                }
                throw new InvalidPayloadException(exchange, type);
            }
            if (type == BasicDBObject.class) {
                Object out = JSON.parse((String)value.toString());
                if (out instanceof BasicDBObject) {
                    return out;
                }
                throw new InvalidPayloadException(exchange, type);
            }
        }
        if (type == DBObject.class) {
            Map m = (Map)OBJECT_MAPPER.convertValue(value, Map.class);
            return new BasicDBObject(m);
        }
        return null;
    }
}

