/*
 * Decompiled with CFR 0.152.
 */
package org.lightcouch;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.lightcouch.CouchDbClient;
import org.lightcouch.CouchDbClientBase;
import org.lightcouch.CouchDbInfo;
import org.lightcouch.CouchDbProperties;
import org.lightcouch.CouchDbUtil;
import org.lightcouch.NoDocumentException;
import org.lightcouch.URIBuilder;

public class CouchDbContext {
    private static final Log log = LogFactory.getLog(CouchDbClient.class);
    private CouchDbClientBase dbc;

    CouchDbContext(CouchDbClientBase dbc, CouchDbProperties props) {
        this.dbc = dbc;
        if (props.isCreateDbIfNotExist()) {
            this.createDB(props.getDbName());
        } else {
            this.serverVersion();
        }
    }

    public void deleteDB(String dbName, String confirm) {
        CouchDbUtil.assertNotEmpty(dbName, "dbName");
        if (!"delete database".equals(confirm)) {
            throw new IllegalArgumentException("Invalid confirm!");
        }
        this.dbc.delete(URIBuilder.buildUri(this.dbc.getBaseUri()).path(dbName).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDB(String dbName) {
        CouchDbUtil.assertNotEmpty(dbName, "dbName");
        InputStream getresp = null;
        HttpResponse putresp = null;
        URI uri = URIBuilder.buildUri(this.dbc.getBaseUri()).path(dbName).build();
        try {
            getresp = this.dbc.get(uri);
        }
        catch (NoDocumentException e) {
            try {
                HttpPut put = new HttpPut(uri);
                putresp = this.dbc.executeRequest((HttpRequestBase)put);
                log.info((Object)String.format("Created Database: '%s'", dbName));
            }
            catch (Throwable throwable) {
                CouchDbUtil.close(getresp);
                CouchDbUtil.close(putresp);
                throw throwable;
            }
            CouchDbUtil.close(getresp);
            CouchDbUtil.close(putresp);
        }
        CouchDbUtil.close(getresp);
        CouchDbUtil.close(putresp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllDbs() {
        List list;
        InputStream instream = null;
        try {
            Type typeOfList = new TypeToken<List<String>>(){}.getType();
            instream = this.dbc.get(URIBuilder.buildUri(this.dbc.getBaseUri()).path("_all_dbs").build());
            InputStreamReader reader = new InputStreamReader(instream);
            list = (List)this.dbc.getGson().fromJson((Reader)reader, typeOfList);
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(instream);
            throw throwable;
        }
        CouchDbUtil.close(instream);
        return list;
    }

    public CouchDbInfo info() {
        return this.dbc.get(URIBuilder.buildUri(this.dbc.getDBUri()).build(), CouchDbInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String serverVersion() {
        String string;
        InputStream instream = null;
        try {
            instream = this.dbc.get(URIBuilder.buildUri(this.dbc.getBaseUri()).build());
            InputStreamReader reader = new InputStreamReader(instream);
            string = CouchDbUtil.getAsString(new JsonParser().parse((Reader)reader).getAsJsonObject(), "version");
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(instream);
            throw throwable;
        }
        CouchDbUtil.close(instream);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compact() {
        HttpResponse response = null;
        try {
            response = this.dbc.post(URIBuilder.buildUri(this.dbc.getDBUri()).path("_compact").build(), "");
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(response);
            throw throwable;
        }
        CouchDbUtil.close(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureFullCommit() {
        HttpResponse response = null;
        try {
            response = this.dbc.post(URIBuilder.buildUri(this.dbc.getDBUri()).path("_ensure_full_commit").build(), "");
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(response);
            throw throwable;
        }
        CouchDbUtil.close(response);
    }

    public List<String> uuids(long count) {
        String uri = String.format("%s_uuids?count=%d", this.dbc.getBaseUri(), count);
        JsonObject json = this.dbc.findAny(JsonObject.class, uri);
        return (List)this.dbc.getGson().fromJson(json.get("uuids").toString(), new TypeToken<List<String>>(){}.getType());
    }
}

