/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.cookie;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;

public final class DateParser {
    private static final DateTimeFormatter PROPER_FORMAT_RFC822 = DateTimeFormatter.RFC_1123_DATE_TIME;
    private static final DateTimeFormatter OBSOLETE_FORMAT1_RFC850 = DateTimeFormatter.ofPattern("EEEE, dd-MMM-yy HH:mm:ss z", Locale.ENGLISH);
    private static final DateTimeFormatter OBSOLETE_FORMAT2_ANSIC = DateTimeFormatter.ofPattern("EEE MMM d HH:mm:ss yyyy", Locale.ENGLISH);

    private static Date parseZonedDateTimeSilent(String text, DateTimeFormatter formatter) {
        try {
            return Date.from(ZonedDateTime.parse(text, formatter).toInstant());
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Date parseDateTimeSilent(String text, DateTimeFormatter formatter) {
        try {
            return Date.from(LocalDateTime.parse(text, formatter).toInstant(ZoneOffset.UTC));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date parse(String text) {
        Date date = DateParser.parseZonedDateTimeSilent(text, PROPER_FORMAT_RFC822);
        if (date == null) {
            date = DateParser.parseZonedDateTimeSilent(text, OBSOLETE_FORMAT1_RFC850);
        }
        if (date == null) {
            date = DateParser.parseDateTimeSilent(text, OBSOLETE_FORMAT2_ANSIC);
        }
        return date;
    }
}

