/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.ReplaceRouteRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ReplaceRouteRequestMarshaller
implements Marshaller<Request<ReplaceRouteRequest>, ReplaceRouteRequest> {
    public Request<ReplaceRouteRequest> marshall(ReplaceRouteRequest replaceRouteRequest) {
        if (replaceRouteRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)replaceRouteRequest, "AmazonEC2");
        request.addParameter("Action", "ReplaceRoute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (replaceRouteRequest.getRouteTableId() != null) {
            request.addParameter("RouteTableId", StringUtils.fromString((String)replaceRouteRequest.getRouteTableId()));
        }
        if (replaceRouteRequest.getDestinationCidrBlock() != null) {
            request.addParameter("DestinationCidrBlock", StringUtils.fromString((String)replaceRouteRequest.getDestinationCidrBlock()));
        }
        if (replaceRouteRequest.getGatewayId() != null) {
            request.addParameter("GatewayId", StringUtils.fromString((String)replaceRouteRequest.getGatewayId()));
        }
        if (replaceRouteRequest.getDestinationIpv6CidrBlock() != null) {
            request.addParameter("DestinationIpv6CidrBlock", StringUtils.fromString((String)replaceRouteRequest.getDestinationIpv6CidrBlock()));
        }
        if (replaceRouteRequest.getEgressOnlyInternetGatewayId() != null) {
            request.addParameter("EgressOnlyInternetGatewayId", StringUtils.fromString((String)replaceRouteRequest.getEgressOnlyInternetGatewayId()));
        }
        if (replaceRouteRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)replaceRouteRequest.getInstanceId()));
        }
        if (replaceRouteRequest.getNetworkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString((String)replaceRouteRequest.getNetworkInterfaceId()));
        }
        if (replaceRouteRequest.getVpcPeeringConnectionId() != null) {
            request.addParameter("VpcPeeringConnectionId", StringUtils.fromString((String)replaceRouteRequest.getVpcPeeringConnectionId()));
        }
        if (replaceRouteRequest.getNatGatewayId() != null) {
            request.addParameter("NatGatewayId", StringUtils.fromString((String)replaceRouteRequest.getNatGatewayId()));
        }
        return request;
    }
}

