/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.List;
import org.springframework.batch.core.step.item.ForceRollbackForWriteSkipException;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ExceptionElementParser {
    public ManagedMap<TypedStringValue, Boolean> parse(Element element, ParserContext parserContext, String exceptionListName) {
        List children = DomUtils.getChildElementsByTagName((Element)element, (String)exceptionListName);
        if (children.size() == 1) {
            ManagedMap map = new ManagedMap();
            Element exceptionClassesElement = (Element)children.get(0);
            this.addExceptionClasses("include", true, exceptionClassesElement, (ManagedMap<TypedStringValue, Boolean>)map, parserContext);
            this.addExceptionClasses("exclude", false, exceptionClassesElement, (ManagedMap<TypedStringValue, Boolean>)map, parserContext);
            map.put((Object)new TypedStringValue(ForceRollbackForWriteSkipException.class.getName(), Class.class), (Object)true);
            return map;
        }
        if (children.size() > 1) {
            parserContext.getReaderContext().error("The <" + exceptionListName + "/> element may not appear more than once in a single <" + element.getNodeName() + "/>.", (Object)element);
        }
        return null;
    }

    private void addExceptionClasses(String elementName, boolean include, Element exceptionClassesElement, ManagedMap<TypedStringValue, Boolean> map, ParserContext parserContext) {
        for (Element child : DomUtils.getChildElementsByTagName((Element)exceptionClassesElement, (String)elementName)) {
            String className = child.getAttribute("class");
            map.put((Object)new TypedStringValue(className, Class.class), (Object)include);
        }
    }
}

