/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.step.builder;

import javax.batch.api.partition.PartitionReducer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.jsr.step.PartitionStep;
import org.springframework.batch.core.partition.support.SimpleStepExecutionSplitter;
import org.springframework.batch.core.partition.support.TaskExecutorPartitionHandler;
import org.springframework.batch.core.step.builder.PartitionStepBuilder;
import org.springframework.batch.core.step.builder.StepBuilderException;
import org.springframework.batch.core.step.builder.StepBuilderHelper;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;

public class JsrPartitionStepBuilder
extends PartitionStepBuilder {
    private PartitionReducer reducer;

    public JsrPartitionStepBuilder(StepBuilderHelper<?> parent) {
        super(parent);
    }

    public JsrPartitionStepBuilder reducer(PartitionReducer reducer) {
        this.reducer = reducer;
        return this;
    }

    @Override
    public JsrPartitionStepBuilder step(Step step) {
        super.step(step);
        return this;
    }

    @Override
    public Step build() {
        PartitionStep step = new PartitionStep();
        step.setName(this.getName());
        super.enhance(step);
        if (this.getPartitionHandler() != null) {
            step.setPartitionHandler(this.getPartitionHandler());
        } else {
            TaskExecutorPartitionHandler partitionHandler = new TaskExecutorPartitionHandler();
            partitionHandler.setStep(this.getStep());
            if (this.getTaskExecutor() == null) {
                this.taskExecutor((TaskExecutor)new SyncTaskExecutor());
            }
            partitionHandler.setGridSize(this.getGridSize());
            partitionHandler.setTaskExecutor(this.getTaskExecutor());
            step.setPartitionHandler(partitionHandler);
        }
        if (this.getSplitter() != null) {
            step.setStepExecutionSplitter(this.getSplitter());
        } else {
            boolean allowStartIfComplete = this.isAllowStartIfComplete();
            String name = this.getStepName();
            if (this.getStep() != null) {
                try {
                    allowStartIfComplete = this.getStep().isAllowStartIfComplete();
                    name = this.getStep().getName();
                }
                catch (Exception e) {
                    this.logger.info((Object)("Ignored exception from step asking for name and allowStartIfComplete flag. Using default from enclosing PartitionStep (" + name + "," + allowStartIfComplete + ")."));
                }
            }
            SimpleStepExecutionSplitter splitter = new SimpleStepExecutionSplitter();
            splitter.setPartitioner(this.getPartitioner());
            splitter.setJobRepository(this.getJobRepository());
            splitter.setAllowStartIfComplete(allowStartIfComplete);
            splitter.setStepName(name);
            this.splitter(splitter);
            step.setStepExecutionSplitter(splitter);
        }
        if (this.getAggregator() != null) {
            step.setStepExecutionAggregator(this.getAggregator());
        }
        if (this.reducer != null) {
            step.setPartitionReducer(this.reducer);
        }
        try {
            step.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new StepBuilderException(e);
        }
        return step;
    }
}

