/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.support;

import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.NameMatchMethodPointcut;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.batch.core.repository.support.SimpleJobRepository;
import org.springframework.batch.support.PropertiesConverter;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public abstract class AbstractJobRepositoryFactoryBean
implements FactoryBean<JobRepository>,
InitializingBean {
    private PlatformTransactionManager transactionManager;
    private ProxyFactory proxyFactory;
    private String isolationLevelForCreate = "ISOLATION_SERIALIZABLE";
    private boolean validateTransactionState = true;
    private static final String DEFAULT_ISOLATION_LEVEL = "ISOLATION_SERIALIZABLE";

    protected abstract JobInstanceDao createJobInstanceDao() throws Exception;

    protected abstract JobExecutionDao createJobExecutionDao() throws Exception;

    protected abstract StepExecutionDao createStepExecutionDao() throws Exception;

    protected abstract ExecutionContextDao createExecutionContextDao() throws Exception;

    public Class<JobRepository> getObjectType() {
        return JobRepository.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setValidateTransactionState(boolean validateTransactionState) {
        this.validateTransactionState = validateTransactionState;
    }

    public void setIsolationLevelForCreate(String isolationLevelForCreate) {
        this.isolationLevelForCreate = isolationLevelForCreate;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public JobRepository getJobRepository() throws Exception {
        return this.getObject();
    }

    private void initializeProxy() throws Exception {
        if (this.proxyFactory == null) {
            this.proxyFactory = new ProxyFactory();
            TransactionInterceptor advice = new TransactionInterceptor(this.transactionManager, PropertiesConverter.stringToProperties((String)("create*=PROPAGATION_REQUIRES_NEW," + this.isolationLevelForCreate + "\ngetLastJobExecution*=PROPAGATION_REQUIRES_NEW," + this.isolationLevelForCreate + "\n*=PROPAGATION_REQUIRED")));
            if (this.validateTransactionState) {
                DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor((Advice)new MethodInterceptor(){

                    public Object invoke(MethodInvocation invocation) throws Throwable {
                        if (TransactionSynchronizationManager.isActualTransactionActive()) {
                            throw new IllegalStateException("Existing transaction detected in JobRepository. Please fix this and try again (e.g. remove @Transactional annotations from client).");
                        }
                        return invocation.proceed();
                    }
                });
                NameMatchMethodPointcut pointcut = new NameMatchMethodPointcut();
                pointcut.addMethodName("create*");
                advisor.setPointcut((Pointcut)pointcut);
                this.proxyFactory.addAdvisor((Advisor)advisor);
            }
            this.proxyFactory.addAdvice((Advice)advice);
            this.proxyFactory.setProxyTargetClass(false);
            this.proxyFactory.addInterface(JobRepository.class);
            this.proxyFactory.setTarget(this.getTarget());
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.transactionManager, (String)"TransactionManager must not be null.");
        this.initializeProxy();
    }

    private Object getTarget() throws Exception {
        return new SimpleJobRepository(this.createJobInstanceDao(), this.createJobExecutionDao(), this.createStepExecutionDao(), this.createExecutionContextDao());
    }

    public JobRepository getObject() throws Exception {
        if (this.proxyFactory == null) {
            this.afterPropertiesSet();
        }
        return (JobRepository)this.proxyFactory.getProxy();
    }
}

