/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser.format.xml;

import java.io.IOException;
import org.beanio.internal.parser.DelegatingParser;
import org.beanio.internal.parser.MarshallingContext;
import org.beanio.internal.parser.UnmarshallingContext;
import org.beanio.internal.parser.format.xml.XmlMarshallingContext;
import org.beanio.internal.parser.format.xml.XmlNode;
import org.beanio.internal.parser.format.xml.XmlNodeUtil;
import org.beanio.internal.parser.format.xml.XmlUnmarshallingContext;
import org.beanio.internal.util.DebugUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlWrapper
extends DelegatingParser
implements XmlNode {
    private String localName;
    private String prefix;
    private String namespace;
    private boolean namespaceAware;
    private boolean nillable;
    private boolean lazy;
    private boolean repeating;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matches(UnmarshallingContext context) {
        if (!this.isIdentifier()) {
            return true;
        }
        XmlUnmarshallingContext ctx = (XmlUnmarshallingContext)context;
        if (ctx.pushPosition(this) == null) {
            return false;
        }
        try {
            boolean bl = super.matches(context);
            return bl;
        }
        finally {
            ctx.popPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unmarshal(UnmarshallingContext context) {
        XmlUnmarshallingContext ctx = (XmlUnmarshallingContext)context;
        if (ctx.pushPosition(this) == null) {
            return false;
        }
        try {
            if (XmlNodeUtil.isNil(ctx.getPosition())) {
                if (!this.isNillable()) {
                    context.addFieldError(this.getName(), null, "nillable", new Object[0]);
                }
            } else {
                super.unmarshal(context);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ctx.popPosition();
        }
    }

    public boolean marshal(MarshallingContext context) throws IOException {
        boolean contentChecked = false;
        if (this.lazy && !this.repeating) {
            if (!this.hasContent(context)) {
                return false;
            }
            contentChecked = true;
        }
        XmlMarshallingContext ctx = (XmlMarshallingContext)context;
        Element element = ctx.getDocument().createElementNS(this.getNamespace(), this.getLocalName());
        if (!this.isNamespaceAware()) {
            element.setUserData("isNamespaceIgnored", Boolean.TRUE, null);
        } else if ("".equals(this.getPrefix())) {
            element.setUserData("isDefaultNamespace", Boolean.TRUE, null);
        } else {
            element.setPrefix(this.getPrefix());
        }
        Node parent = ctx.getParent();
        parent.appendChild(element);
        if (this.isNillable() && !contentChecked && !this.hasContent(context)) {
            element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
        } else {
            ctx.setParent(element);
            super.marshal(context);
            ctx.setParent(parent);
        }
        return true;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public void setNillable(boolean nillable) {
        this.nillable = nillable;
    }

    public int getType() {
        return 2;
    }

    public boolean isRepeating() {
        return this.repeating;
    }

    public void setRepeating(boolean repeating) {
        this.repeating = repeating;
    }

    public boolean isOptional() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    protected void toParamString(StringBuilder s) {
        super.toParamString(s);
        s.append(", element=").append(this.localName);
        if (this.prefix != null) {
            s.append(", prefix=").append(this.prefix);
        }
        if (this.namespace != null) {
            s.append(", xmlns=").append(this.isNamespaceAware() ? this.namespace : "*");
        }
        s.append(", ").append(DebugUtil.formatOption("lazy", this.lazy));
        s.append(", ").append(DebugUtil.formatOption("nillable", this.nillable));
        s.append(", ").append(DebugUtil.formatOption("repeating", this.repeating));
    }
}

