/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.stream.delimited;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.beanio.stream.RecordIOException;
import org.beanio.stream.RecordReader;
import org.beanio.stream.delimited.DelimitedParserConfiguration;
import org.beanio.stream.util.CommentReader;

public class DelimitedReader
implements RecordReader {
    private char delim = (char)9;
    private char escapeChar = (char)92;
    private char lineContinuationChar = (char)92;
    private char recordTerminator = '\u0000';
    private boolean multilineEnabled = false;
    private boolean escapeEnabled = false;
    private CommentReader commentReader = null;
    private transient Reader in;
    private transient String recordText;
    private transient int recordLineNumber;
    private transient int lineNumber = 0;
    private transient boolean skipLF = false;
    private transient List<String> fieldList = new ArrayList<String>();

    public DelimitedReader(Reader in) {
        this(in, null);
    }

    public DelimitedReader(Reader in, char delimiter) {
        this(in, new DelimitedParserConfiguration(delimiter));
    }

    public DelimitedReader(Reader in, DelimitedParserConfiguration config) {
        if (config == null) {
            config = new DelimitedParserConfiguration();
        }
        this.in = in;
        this.delim = config.getDelimiter();
        if (config.getEscape() != null) {
            this.escapeEnabled = true;
            this.escapeChar = config.getEscape().charValue();
            if (this.delim == this.escapeChar) {
                throw new IllegalArgumentException("The field delimiter canot match the escape character");
            }
        }
        if (config.getLineContinuationCharacter() != null) {
            this.multilineEnabled = true;
            this.lineContinuationChar = config.getLineContinuationCharacter().charValue();
            if (this.delim == this.lineContinuationChar) {
                throw new IllegalArgumentException("The field delimiter cannot match the line continuation character");
            }
        }
        if (config.getRecordTerminator() != null) {
            String s = config.getRecordTerminator();
            if (!"\r\n".equals(s)) {
                if (s.length() == 1) {
                    this.recordTerminator = s.charAt(0);
                } else if (s.length() > 1) {
                    throw new IllegalArgumentException("Record terminator must be a single character");
                }
            }
            if (this.recordTerminator == this.delim) {
                throw new IllegalArgumentException("The record delimiter and record terminator characters cannot match");
            }
            if (this.multilineEnabled && this.recordTerminator == this.lineContinuationChar) {
                throw new IllegalArgumentException("The line continuation character and record terminator cannot match");
            }
        }
        if (config.isCommentEnabled()) {
            this.commentReader = new CommentReader(in, config.getComments(), Character.valueOf(this.recordTerminator));
        }
    }

    public int getRecordLineNumber() {
        if (this.recordLineNumber < 0) {
            return -1;
        }
        return this.recordTerminator == '\u0000' ? this.recordLineNumber : 0;
    }

    public String getRecordText() {
        return this.recordText;
    }

    public String[] read() throws IOException {
        int n;
        int lines;
        if (this.fieldList == null) {
            this.recordText = null;
            this.recordLineNumber = -1;
            return null;
        }
        ++this.lineNumber;
        if (this.commentReader != null && (lines = this.commentReader.skipComments(this.skipLF)) > 0) {
            if (this.commentReader.isEOF()) {
                this.fieldList = null;
                this.recordText = null;
                this.recordLineNumber = -1;
                return null;
            }
            this.lineNumber += lines;
            this.skipLF = this.commentReader.isSkipLF();
        }
        int lineOffset = 0;
        this.fieldList.clear();
        boolean continued = false;
        boolean escaped = false;
        boolean eol = false;
        StringBuilder text = new StringBuilder();
        StringBuilder field = new StringBuilder();
        while (!eol && (n = this.in.read()) != -1) {
            char c = (char)n;
            if (this.skipLF) {
                this.skipLF = false;
                if (c == '\n') continue;
            }
            if (continued) {
                continued = false;
                text.append(c);
                if (this.endOfRecord(c, true)) {
                    escaped = false;
                    ++this.lineNumber;
                    ++lineOffset;
                    continue;
                }
                if (!escaped) {
                    field.append(this.lineContinuationChar);
                }
            } else if (!this.endOfRecord(c, false)) {
                text.append(c);
            }
            if (escaped) {
                escaped = false;
                if (c == this.delim) {
                    field.append(c);
                    continue;
                }
                if (c == this.escapeChar) {
                    field.append(this.escapeChar);
                    continue;
                }
                field.append(this.escapeChar);
            }
            if (this.escapeEnabled && c == this.escapeChar) {
                escaped = true;
                if (!this.multilineEnabled || c != this.lineContinuationChar) continue;
                continued = true;
                continue;
            }
            if (this.multilineEnabled && c == this.lineContinuationChar) {
                continued = true;
                continue;
            }
            if (c == this.delim) {
                this.fieldList.add(field.toString());
                field = new StringBuilder();
                continue;
            }
            if (this.endOfRecord(c, true)) {
                this.fieldList.add(field.toString());
                eol = true;
                continue;
            }
            field.append(c);
        }
        this.recordLineNumber = this.lineNumber - lineOffset;
        this.recordText = text.toString();
        if (eol) {
            this.recordText = text.toString();
            String[] record = new String[this.fieldList.size()];
            return this.fieldList.toArray(record);
        }
        if (continued) {
            this.fieldList = null;
            this.recordText = null;
            this.recordLineNumber = -1;
            throw new RecordIOException("Unexpected end of stream after line continuation at line " + this.lineNumber);
        }
        if (escaped) {
            field.append(this.escapeChar);
        }
        if (text.length() > 0) {
            this.fieldList.add(field.toString());
            String[] record = new String[this.fieldList.size()];
            record = this.fieldList.toArray(record);
            this.recordText = text.toString();
            this.fieldList = null;
            return record;
        }
        this.fieldList = null;
        this.recordText = null;
        this.recordLineNumber = -1;
        return null;
    }

    private boolean endOfRecord(char c, boolean skipLF) {
        if (this.recordTerminator == '\u0000') {
            if (c == '\r') {
                this.skipLF = skipLF;
                return true;
            }
            return c == '\n';
        }
        return c == this.recordTerminator;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

