/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import brave.Clock;
import brave.Span;
import brave.Tracer;
import brave.internal.Internal;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContext;
import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.Recorder;
import com.github.kristofa.brave.ServerClientAndLocalSpanState;
import com.github.kristofa.brave.ServerSpan;
import com.github.kristofa.brave.ServerSpanThreadBinder;
import com.github.kristofa.brave.SpanFactory;
import com.github.kristofa.brave.SpanId;
import com.github.kristofa.brave.ThreadLocalServerClientAndLocalSpanState;
import com.github.kristofa.brave.TracerAdapter$$Lambda$1;
import com.github.kristofa.brave.internal.InternalSpan;
import com.twitter.zipkin.gen.Endpoint;

public final class TracerAdapter {
    static final Endpoint DUMMY_ENDPOINT = Endpoint.builder().serviceName("not used").build();

    public static Brave newBrave(Tracer tracer) {
        if (tracer == null) {
            throw new NullPointerException("tracer == null");
        }
        return TracerAdapter.newBrave(tracer, new ThreadLocalServerClientAndLocalSpanState(DUMMY_ENDPOINT));
    }

    public static Brave newBrave(Tracer tracer, ServerClientAndLocalSpanState state) {
        if (tracer == null) {
            throw new NullPointerException("tracer == null");
        }
        if (state == null) {
            throw new NullPointerException("state == null");
        }
        Brave.Builder builder = new Brave.Builder(state);
        Clock clock = tracer.clock();
        clock.getClass();
        return builder.clock(TracerAdapter$$Lambda$1.lambdaFactory$(clock)).spanFactory(new Brave4SpanFactory(tracer)).recorder(new Brave4Recorder(tracer)).build();
    }

    public static Span toSpan(Tracer tracer, com.twitter.zipkin.gen.Span span) {
        if (tracer == null) {
            throw new NullPointerException("tracer == null");
        }
        return tracer.toSpan(TracerAdapter.toTraceContext(Brave.context(span)));
    }

    public static Span toSpan(Tracer tracer, SpanId spanId) {
        if (tracer == null) {
            throw new NullPointerException("tracer == null");
        }
        return tracer.toSpan(TracerAdapter.toTraceContext(spanId));
    }

    public static Span getServerSpan(Tracer tracer, ServerSpanThreadBinder threadBinder) {
        if (tracer == null) {
            throw new NullPointerException("tracer == null");
        }
        if (threadBinder == null) {
            throw new NullPointerException("threadBinder == null");
        }
        ServerSpan result = threadBinder.getCurrentServerSpan();
        if (result == null || result.equals(ServerSpan.EMPTY)) {
            return null;
        }
        if (result.getSpan() != null) {
            return TracerAdapter.toSpan(tracer, result.getSpan());
        }
        assert (result.getSample() != null && !result.getSample().booleanValue()) : "unexpected sample state: " + result;
        return tracer.newTrace(SamplingFlags.NOT_SAMPLED);
    }

    public static void setServerSpan(TraceContext context, ServerSpanThreadBinder threadBinder) {
        if (threadBinder == null) {
            throw new NullPointerException("threadBinder == null");
        }
        ServerSpan serverSpan = ServerSpan.create(TracerAdapter.toSpan(context));
        threadBinder.setCurrentSpan(serverSpan);
    }

    static TraceContext toTraceContext(SpanId spanId) {
        if (spanId == null) {
            throw new NullPointerException("spanId == null");
        }
        return TraceContext.newBuilder().traceIdHigh(spanId.traceIdHigh).traceId(spanId.traceId).parentId(spanId.nullableParentId()).spanId(spanId.spanId).debug(spanId.debug()).sampled(spanId.sampled()).shared(spanId.shared).build();
    }

    public static com.twitter.zipkin.gen.Span toSpan(TraceContext context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        return InternalSpan.instance.toSpan(TracerAdapter.toSpanId(context));
    }

    static SpanId toSpanId(TraceContext context) {
        return SpanId.builder().traceIdHigh(context.traceIdHigh()).traceId(context.traceId()).parentId(context.parentId()).spanId(context.spanId()).debug(context.debug()).sampled(context.sampled()).shared(context.shared()).build();
    }

    static final class Brave4Recorder
    extends Recorder {
        final Tracer tracer;

        Brave4Recorder(Tracer tracer) {
            this.tracer = tracer;
        }

        @Override
        void name(com.twitter.zipkin.gen.Span span, String name) {
            this.brave4(span).name(name);
        }

        @Override
        void start(com.twitter.zipkin.gen.Span span, long timestamp) {
            this.brave4(span).start(timestamp);
        }

        @Override
        Long timestamp(com.twitter.zipkin.gen.Span span) {
            TraceContext context = TracerAdapter.toTraceContext(InternalSpan.instance.context(span));
            return Internal.instance.timestamp(this.tracer, context);
        }

        @Override
        void annotate(com.twitter.zipkin.gen.Span span, long timestamp, String value) {
            this.brave4(span).annotate(timestamp, value);
        }

        @Override
        void address(com.twitter.zipkin.gen.Span span, String key, Endpoint endpoint) {
            Span brave4 = this.brave4(span);
            String string = key;
            int n = -1;
            switch (string.hashCode()) {
                case 3662: {
                    if (!string.equals("sa")) break;
                    n = 0;
                    break;
                }
                case 3166: {
                    if (!string.equals("ca")) break;
                    n = 1;
                }
            }
            switch (n) {
                case 0: {
                    brave4.kind(Span.Kind.CLIENT);
                    break;
                }
                case 1: {
                    brave4.kind(Span.Kind.SERVER);
                    break;
                }
                default: {
                    throw new AssertionError((Object)(key + " is not yet supported"));
                }
            }
            brave4.remoteEndpoint(zipkin.Endpoint.builder().serviceName(endpoint.service_name).ipv4(endpoint.ipv4).ipv6(endpoint.ipv6).port(endpoint.port).build());
        }

        @Override
        void tag(com.twitter.zipkin.gen.Span span, String key, String value) {
            this.brave4(span).tag(key, value);
        }

        @Override
        void finish(com.twitter.zipkin.gen.Span span, long timestamp) {
            this.brave4(span).finish(timestamp);
        }

        @Override
        void flush(com.twitter.zipkin.gen.Span span) {
            this.brave4(span).flush();
        }

        Span brave4(com.twitter.zipkin.gen.Span span) {
            return this.tracer.toSpan(TracerAdapter.toTraceContext(InternalSpan.instance.context(span)));
        }

        @Override
        public long currentTimeMicroseconds() {
            return this.tracer.clock().currentTimeMicroseconds();
        }
    }

    static final class Brave4SpanFactory
    extends SpanFactory {
        final Tracer delegate;

        Brave4SpanFactory(Tracer tracer) {
            this.delegate = tracer;
        }

        @Override
        com.twitter.zipkin.gen.Span nextSpan(SpanId maybeParent) {
            Span span = maybeParent != null ? this.delegate.newChild(TracerAdapter.toTraceContext(maybeParent)) : this.delegate.newTrace();
            return Brave.toSpan(TracerAdapter.toSpanId(span.context()));
        }

        @Override
        com.twitter.zipkin.gen.Span joinSpan(SpanId spanId) {
            TraceContext context = TracerAdapter.toTraceContext(spanId);
            return Brave.toSpan(TracerAdapter.toSpanId(this.delegate.joinSpan(context).context()));
        }
    }
}

