/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.internal;

import com.github.kristofa.brave.SpanId;
import com.github.kristofa.brave.internal.InternalSpan;
import com.twitter.zipkin.gen.Annotation;
import com.twitter.zipkin.gen.AnnotationType;
import com.twitter.zipkin.gen.Endpoint;
import com.twitter.zipkin.gen.Span;
import com.twitter.zipkin.gen.SpanCodec;
import java.util.ArrayList;
import java.util.List;
import zipkin.BinaryAnnotation;
import zipkin.Codec;
import zipkin.Span;

public final class DefaultSpanCodec
implements SpanCodec {
    public static final SpanCodec JSON = new DefaultSpanCodec((Codec)Codec.JSON);
    public static final SpanCodec THRIFT = new DefaultSpanCodec((Codec)Codec.THRIFT);
    private final Codec codec;

    private DefaultSpanCodec(Codec codec) {
        this.codec = codec;
    }

    @Override
    public byte[] writeSpan(Span span) {
        return this.codec.writeSpan(DefaultSpanCodec.toZipkin(span));
    }

    @Override
    public byte[] writeSpans(List<Span> spans) {
        ArrayList<zipkin.Span> out = new ArrayList<zipkin.Span>(spans.size());
        for (Span span : spans) {
            out.add(DefaultSpanCodec.toZipkin(span));
        }
        return this.codec.writeSpans(out);
    }

    @Override
    public Span readSpan(byte[] bytes) {
        return DefaultSpanCodec.fromZipkin(this.codec.readSpan(bytes));
    }

    public static Span fromZipkin(zipkin.Span in) {
        Span result = DefaultSpanCodec.newSpan(SpanId.builder().traceIdHigh(in.traceIdHigh).traceId(in.traceId).spanId(in.id).parentId(in.parentId).debug(in.debug != null ? in.debug : false).build());
        result.setName(in.name);
        result.setTimestamp(in.timestamp);
        result.setDuration(in.duration);
        for (zipkin.Annotation a : in.annotations) {
            result.addToAnnotations(Annotation.create(a.timestamp, a.value, DefaultSpanCodec.to(a.endpoint)));
        }
        for (zipkin.Annotation a : in.binaryAnnotations) {
            result.addToBinary_annotations(com.twitter.zipkin.gen.BinaryAnnotation.create(a.key, a.value, AnnotationType.fromValue(a.type.value), DefaultSpanCodec.to(a.endpoint)));
        }
        return result;
    }

    private static Endpoint to(zipkin.Endpoint host) {
        if (host == null) {
            return null;
        }
        return Endpoint.builder().ipv4(host.ipv4).ipv6(host.ipv6).port(host.port).serviceName(host.serviceName).build();
    }

    public static zipkin.Span toZipkin(Span span) {
        Span.Builder result = zipkin.Span.builder();
        result.traceId(span.getTrace_id());
        result.traceIdHigh(span.getTrace_id_high());
        result.id(span.getId());
        result.parentId(span.getParent_id());
        result.name(span.getName());
        result.timestamp(span.getTimestamp());
        result.duration(span.getDuration());
        result.debug(span.isDebug());
        for (Annotation annotation : span.getAnnotations()) {
            result.addAnnotation(zipkin.Annotation.create((long)annotation.timestamp, (String)annotation.value, (zipkin.Endpoint)DefaultSpanCodec.from(annotation.host)));
        }
        for (com.twitter.zipkin.gen.BinaryAnnotation binaryAnnotation : span.getBinary_annotations()) {
            result.addBinaryAnnotation(BinaryAnnotation.builder().key(binaryAnnotation.key).value(binaryAnnotation.value).type(BinaryAnnotation.Type.fromValue((int)binaryAnnotation.type.getValue())).endpoint(DefaultSpanCodec.from(binaryAnnotation.host)).build());
        }
        return result.build();
    }

    private static zipkin.Endpoint from(Endpoint host) {
        if (host == null) {
            return null;
        }
        return zipkin.Endpoint.builder().ipv4(host.ipv4).ipv6(host.ipv6).port(host.port).serviceName(host.service_name).build();
    }

    static Span newSpan(SpanId context) {
        return InternalSpan.instance.toSpan(context);
    }
}

