/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.zipkin.gen;

import com.github.kristofa.brave.SpanId;
import com.github.kristofa.brave.internal.InternalSpan;
import com.github.kristofa.brave.internal.Util;
import com.twitter.zipkin.gen.Annotation;
import com.twitter.zipkin.gen.BinaryAnnotation;
import com.twitter.zipkin.gen.SpanCodec;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class Span
implements Serializable {
    static final long serialVersionUID = 1L;
    private SpanId context;
    private long trace_id;
    private long trace_id_high;
    private String name;
    private long id;
    private Long parent_id;
    private List<Annotation> annotations = Collections.emptyList();
    private List<BinaryAnnotation> binary_annotations = Collections.emptyList();
    private Boolean debug;
    private Long timestamp;
    private Long duration;

    @Deprecated
    public Span() {
        this.context = null;
    }

    Span(SpanId context) {
        this.context = context;
        this.trace_id_high = context.traceIdHigh;
        this.trace_id = context.traceId;
        this.parent_id = context.nullableParentId();
        this.id = context.spanId;
        this.name = "";
        if (context.debug()) {
            this.debug = true;
        }
    }

    public long getTrace_id() {
        return this.trace_id;
    }

    @Deprecated
    public Span setTrace_id(long trace_id) {
        assert (false) : "do not modify the context of a span once created";
        this.trace_id = trace_id;
        return this;
    }

    public long getTrace_id_high() {
        return this.trace_id_high;
    }

    @Deprecated
    public Span setTrace_id_high(long trace_id_high) {
        assert (false) : "do not modify the context of a span once created";
        this.trace_id_high = trace_id_high;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Span setName(String name) {
        this.name = name == null || name.isEmpty() ? "" : name.toLowerCase(Locale.ROOT);
        return this;
    }

    public long getId() {
        return this.id;
    }

    @Deprecated
    public Span setId(long id) {
        assert (false) : "do not modify the context of a span once created";
        this.id = id;
        return this;
    }

    public Long getParent_id() {
        return this.parent_id;
    }

    @Deprecated
    public Span setParent_id(Long parent_id) {
        assert (false) : "do not modify the context of a span once created";
        this.parent_id = parent_id;
        return this;
    }

    public Span addToAnnotations(Annotation elem) {
        if (this.annotations == Collections.EMPTY_LIST) {
            this.annotations = new ArrayList<Annotation>();
        }
        this.annotations.add(elem);
        return this;
    }

    public List<Annotation> getAnnotations() {
        return Collections.unmodifiableList(this.annotations);
    }

    public Span setAnnotations(List<Annotation> annotations) {
        if (this.annotations != Collections.EMPTY_LIST) {
            this.annotations.clear();
        }
        for (Annotation a : annotations) {
            this.addToAnnotations(a);
        }
        return this;
    }

    public Span addToBinary_annotations(BinaryAnnotation elem) {
        if (this.binary_annotations == Collections.EMPTY_LIST) {
            this.binary_annotations = new ArrayList<BinaryAnnotation>();
        }
        this.binary_annotations.add(elem);
        return this;
    }

    public List<BinaryAnnotation> getBinary_annotations() {
        return Collections.unmodifiableList(this.binary_annotations);
    }

    public Span setBinaryAnnotations(List<BinaryAnnotation> binary_annotations) {
        if (this.binary_annotations != Collections.EMPTY_LIST) {
            this.binary_annotations.clear();
        }
        for (BinaryAnnotation b : binary_annotations) {
            this.addToBinary_annotations(b);
        }
        return this;
    }

    public Boolean isDebug() {
        return this.debug;
    }

    @Deprecated
    public Span setDebug(Boolean debug) {
        assert (false) : "do not modify the context of a span once created";
        this.debug = debug;
        return this;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Span setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Long getDuration() {
        return this.duration;
    }

    public Span setDuration(Long duration) {
        this.duration = duration;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Span)) {
            return false;
        }
        Span that = (Span)o;
        return this.trace_id_high == that.trace_id_high && this.trace_id == that.trace_id && this.name.equals(that.name) && this.id == that.id && Util.equal(this.parent_id, that.parent_id) && Util.equal(this.timestamp, that.timestamp) && Util.equal(this.duration, that.duration) && Util.equal(this.annotations, that.annotations) && Util.equal(this.binary_annotations, that.binary_annotations) && Util.equal(this.debug, that.debug);
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h = (int)((long)h ^ (this.trace_id_high >>> 32 ^ this.trace_id_high));
        h *= 1000003;
        h = (int)((long)h ^ (this.trace_id >>> 32 ^ this.trace_id));
        h *= 1000003;
        h ^= this.name.hashCode();
        h *= 1000003;
        h = (int)((long)h ^ (this.id >>> 32 ^ this.id));
        h *= 1000003;
        h ^= this.parent_id == null ? 0 : this.parent_id.hashCode();
        h *= 1000003;
        h ^= this.timestamp == null ? 0 : this.timestamp.hashCode();
        h *= 1000003;
        h ^= this.duration == null ? 0 : this.duration.hashCode();
        h *= 1000003;
        h ^= this.annotations == null ? 0 : this.annotations.hashCode();
        h *= 1000003;
        h ^= this.binary_annotations == null ? 0 : this.binary_annotations.hashCode();
        h *= 1000003;
        return h ^= this.debug == null ? 0 : this.debug.hashCode();
    }

    public String toString() {
        return new String(SpanCodec.JSON.writeSpan(this), Util.UTF_8);
    }

    static {
        InternalSpan.instance = new InternalSpan(){

            @Override
            public Span toSpan(SpanId context) {
                return new Span(context);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SpanId context(Span span) {
                if (span.context != null) {
                    return span.context;
                }
                if (span.trace_id == 0L && span.parent_id == null && span.id == 0L) {
                    return null;
                }
                Span span2 = span;
                synchronized (span2) {
                    if (span.context != null) {
                        return span.context;
                    }
                    span.context = SpanId.builder().traceIdHigh(span.getTrace_id_high()).traceId(span.getTrace_id()).parentId(span.getParent_id()).spanId(span.getId()).debug(span.debug != null ? span.debug : false).build();
                }
                return span.context;
            }
        };
    }
}

