/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.uri.expression;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.odata2.api.edm.EdmLiteral;
import org.apache.olingo.odata2.api.edm.EdmLiteralException;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeFacade;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.uri.expression.ExpressionParserException;
import org.apache.olingo.odata2.core.edm.EdmSimpleTypeFacadeImpl;
import org.apache.olingo.odata2.core.uri.expression.FilterParserExceptionImpl;
import org.apache.olingo.odata2.core.uri.expression.TokenKind;
import org.apache.olingo.odata2.core.uri.expression.TokenList;
import org.apache.olingo.odata2.core.uri.expression.TokenizerException;

public class Tokenizer {
    private static final Pattern OTHER_LIT = Pattern.compile("(?:\\p{L}|\\p{Digit}|[-._~%!$&*+;:@])+");
    private static final Pattern FUNK = Pattern.compile("^(startswith|endswith|substring|substring|substringof|indexof|replace|tolower|toupper|trim|concat|length|year|mounth|day|hour|minute|second|round|ceiling|floor)( *)\\(");
    private static final Pattern AND_SUB1 = Pattern.compile("^(add|sub|mul|div|mod|not) ");
    private static final Pattern AND_SUB = Pattern.compile("^(and|or|eq|ne|lt|gt|le|ge) ");
    private static final Pattern prefix = Pattern.compile("^(X|binary|guid|datetime|datetimeoffset|time)'");
    private boolean flagIncludeWhitespace = false;
    private EdmSimpleTypeFacade typeDectector = new EdmSimpleTypeFacadeImpl();
    int curPosition;
    final String expression;
    final int expressionLength;
    TokenList tokens;

    public Tokenizer(String expression) {
        this.expression = expression;
        this.expressionLength = expression.length();
        this.tokens = new TokenList();
    }

    public Tokenizer setFlagWhiteSpace(Boolean flagIncludeWhitespace) {
        this.flagIncludeWhitespace = flagIncludeWhitespace;
        return this;
    }

    public TokenList tokenize() throws TokenizerException, ExpressionParserException {
        this.curPosition = 0;
        String token = "";
        block8: while (this.curPosition < this.expressionLength) {
            boolean isLiteral;
            boolean isBoolean;
            boolean isFunction;
            boolean isMath;
            boolean isPrefix;
            int oldPosition = this.curPosition;
            char curCharacter = this.expression.charAt(this.curPosition);
            switch (curCharacter) {
                case ' ': {
                    this.eatWhiteSpaces(this.curPosition, curCharacter);
                    continue block8;
                }
                case '(': {
                    this.tokens.appendToken(this.curPosition, TokenKind.OPENPAREN, curCharacter);
                    ++this.curPosition;
                    continue block8;
                }
                case ')': {
                    this.tokens.appendToken(this.curPosition, TokenKind.CLOSEPAREN, curCharacter);
                    ++this.curPosition;
                    continue block8;
                }
                case '\'': {
                    token = "";
                    this.readLiteral(curCharacter);
                    continue block8;
                }
                case ',': {
                    this.tokens.appendToken(oldPosition, TokenKind.COMMA, curCharacter);
                    ++this.curPosition;
                    continue block8;
                }
                case '*': 
                case '.': 
                case '/': 
                case '=': 
                case '?': {
                    ++this.curPosition;
                    this.tokens.appendToken(oldPosition, TokenKind.SYMBOL, curCharacter);
                    continue block8;
                }
            }
            String rem_expr = this.expression.substring(this.curPosition);
            boolean isBinary = this.checkForBinary(oldPosition, rem_expr);
            if (isBinary || (isPrefix = this.checkForPrefix(rem_expr)) || (isMath = this.checkForMath(oldPosition, rem_expr)) || (isFunction = this.checkForMethod(oldPosition, rem_expr)) || (isBoolean = this.checkForBoolean(oldPosition, rem_expr)) || (isLiteral = this.checkForLiteral(oldPosition, curCharacter, rem_expr))) continue;
            token = new Character(curCharacter).toString();
            throw TokenizerException.createUNKNOWN_CHARACTER(oldPosition, token, this.expression);
        }
        return this.tokens;
    }

    private boolean checkForLiteral(int oldPosition, char curCharacter, String rem_expr) {
        Matcher matcher = OTHER_LIT.matcher(rem_expr);
        boolean isLiteral = false;
        if (matcher.lookingAt()) {
            String token = matcher.group();
            try {
                EdmLiteral edmLiteral = this.typeDectector.parseUriLiteral(token);
                this.curPosition += token.length();
                this.tokens.appendEdmTypedToken(oldPosition, TokenKind.SIMPLE_TYPE, token, edmLiteral);
                isLiteral = true;
            }
            catch (EdmLiteralException e) {
                if (curCharacter == '-') {
                    ++this.curPosition;
                    this.tokens.appendToken(oldPosition, TokenKind.SYMBOL, curCharacter);
                    isLiteral = true;
                }
                this.curPosition += token.length();
                this.tokens.appendToken(oldPosition, TokenKind.LITERAL, token);
                isLiteral = true;
            }
        }
        return isLiteral;
    }

    private boolean checkForBoolean(int oldPosition, String rem_expr) {
        boolean isBoolean = false;
        if (rem_expr.equals("true") || rem_expr.equals("false")) {
            this.curPosition += rem_expr.length();
            this.tokens.appendEdmTypedToken(oldPosition, TokenKind.SIMPLE_TYPE, rem_expr, new EdmLiteral(EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.Boolean), rem_expr));
            isBoolean = true;
        }
        return isBoolean;
    }

    private void eatWhiteSpaces(int oldPosition, char curCharacter) {
        while (curCharacter == ' ' && this.curPosition < this.expressionLength) {
            ++this.curPosition;
            if (this.curPosition >= this.expressionLength) continue;
            curCharacter = this.expression.charAt(this.curPosition);
        }
        int lv_token_len = this.curPosition - oldPosition;
        if (this.flagIncludeWhitespace) {
            String expression_sub = this.expression.substring(oldPosition, oldPosition + lv_token_len);
            this.tokens.appendEdmTypedToken(oldPosition, TokenKind.WHITESPACE, expression_sub, null);
        }
    }

    private boolean checkForMethod(int oldPosition, String rem_expr) {
        boolean isMethod = false;
        Matcher matcher = FUNK.matcher(rem_expr);
        if (matcher.find()) {
            String token = matcher.group(1);
            this.curPosition += token.length();
            this.tokens.appendToken(oldPosition, TokenKind.LITERAL, token);
            isMethod = true;
        }
        return isMethod;
    }

    private boolean checkForMath(int oldPosition, String rem_expr) {
        boolean isMath = false;
        Matcher matcher1 = AND_SUB1.matcher(rem_expr);
        if (matcher1.find()) {
            String token = matcher1.group(1);
            this.curPosition += token.length();
            this.tokens.appendToken(oldPosition, TokenKind.LITERAL, token);
            isMath = true;
        }
        return isMath;
    }

    private boolean checkForBinary(int oldPosition, String rem_expr) {
        boolean isBinary = false;
        Matcher matcher1 = AND_SUB.matcher(rem_expr);
        if (matcher1.find()) {
            String token = matcher1.group(1);
            this.curPosition += token.length();
            this.tokens.appendToken(oldPosition, TokenKind.LITERAL, token);
            isBinary = true;
        }
        return isBinary;
    }

    private boolean checkForPrefix(String rem_expr) throws ExpressionParserException, TokenizerException {
        boolean isPrefix = false;
        Matcher matcher = prefix.matcher(rem_expr);
        String token = "";
        if (matcher.find()) {
            token = matcher.group(1);
            this.curPosition += token.length();
            char curCharacter = this.expression.charAt(this.curPosition);
            this.readLiteral(curCharacter, token);
            isPrefix = true;
        }
        return isPrefix;
    }

    private void readLiteral(char curCharacter) throws ExpressionParserException, TokenizerException {
        this.readLiteral(curCharacter, "");
    }

    private void readLiteral(char curCharacter, String token) throws ExpressionParserException, TokenizerException {
        int offsetPos = -token.length();
        int oldPosition = this.curPosition++;
        token = token + Character.toString(curCharacter);
        boolean wasApostroph = false;
        while (this.curPosition < this.expressionLength) {
            curCharacter = this.expression.charAt(this.curPosition);
            if (curCharacter != '\'') {
                if (wasApostroph) break;
                token = token + curCharacter;
                wasApostroph = false;
            } else {
                wasApostroph = !wasApostroph;
                token = token + curCharacter;
            }
            ++this.curPosition;
        }
        if (!wasApostroph) {
            throw FilterParserExceptionImpl.createTOKEN_UNDETERMINATED_STRING(oldPosition, this.expression);
        }
        try {
            EdmLiteral edmLiteral = this.typeDectector.parseUriLiteral(token);
            this.tokens.appendEdmTypedToken(oldPosition + offsetPos, TokenKind.SIMPLE_TYPE, token, edmLiteral);
        }
        catch (EdmLiteralException ex) {
            throw TokenizerException.createTYPEDECTECTION_FAILED_ON_STRING(ex, oldPosition, token);
        }
    }
}

