/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.cookie;

import org.asynchttpclient.cookie.CookieUtil;

public class Cookie {
    private final String name;
    private final String value;
    private final boolean wrap;
    private final String domain;
    private final String path;
    private final long maxAge;
    private final boolean secure;
    private final boolean httpOnly;

    public static Cookie newValidCookie(String name, String value, boolean wrap, String domain, String path, long maxAge, boolean secure, boolean httpOnly) {
        return new Cookie(CookieUtil.validateCookieName(name), CookieUtil.validateCookieValue(value), wrap, CookieUtil.validateCookieAttribute("domain", domain), CookieUtil.validateCookieAttribute("path", path), maxAge, secure, httpOnly);
    }

    public Cookie(String name, String value, boolean wrap, String domain, String path, long maxAge, boolean secure, boolean httpOnly) {
        this.name = name;
        this.value = value;
        this.wrap = wrap;
        this.domain = domain;
        this.path = path;
        this.maxAge = maxAge;
        this.secure = secure;
        this.httpOnly = httpOnly;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public String getPath() {
        return this.path;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.name);
        buf.append('=');
        if (this.wrap) {
            buf.append('\"').append(this.value).append('\"');
        } else {
            buf.append(this.value);
        }
        if (this.domain != null) {
            buf.append("; domain=");
            buf.append(this.domain);
        }
        if (this.path != null) {
            buf.append("; path=");
            buf.append(this.path);
        }
        if (this.maxAge >= 0L) {
            buf.append("; maxAge=");
            buf.append(this.maxAge);
            buf.append('s');
        }
        if (this.secure) {
            buf.append("; secure");
        }
        if (this.httpOnly) {
            buf.append("; HTTPOnly");
        }
        return buf.toString();
    }
}

