/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.UnsignedInteger32;

public class Counter32
extends UnsignedInteger32 {
    private static final long serialVersionUID = 6140742767439142144L;

    public Counter32() {
    }

    public Counter32(long value) {
        super(value);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Counter32) {
            return ((Counter32)o).getValue() == this.getValue();
        }
        return false;
    }

    @Override
    public int getSyntax() {
        return 65;
    }

    @Override
    public void encodeBER(OutputStream outputStream) throws IOException {
        BER.encodeUnsignedInteger(outputStream, (byte)65, this.getValue());
    }

    @Override
    public void decodeBER(BERInputStream inputStream) throws IOException {
        BER.MutableByte type = new BER.MutableByte();
        long newValue = BER.decodeUnsignedInteger(inputStream, type);
        if (type.getValue() != 65) {
            throw new IOException("Wrong type encountered when decoding Counter: " + type.getValue());
        }
        this.setValue(newValue);
    }

    @Override
    public Object clone() {
        return new Counter32(this.value);
    }

    public void increment() {
        this.value = this.value < 0xFFFFFFFFL ? ++this.value : 0L;
    }

    @Override
    public OID toSubIndex(boolean impliedLength) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fromSubIndex(OID subIndex, boolean impliedLength) {
        throw new UnsupportedOperationException();
    }
}

