/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.spi.StateRepository;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InterruptException;

public class KafkaConsumer
extends DefaultConsumer {
    protected ExecutorService executor;
    private final KafkaEndpoint endpoint;
    private final Processor processor;
    private final Long pollTimeoutMs;
    private final List<KafkaFetchRecords> tasks = new ArrayList<KafkaFetchRecords>();

    public KafkaConsumer(KafkaEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.processor = processor;
        this.pollTimeoutMs = endpoint.getConfiguration().getPollTimeoutMs();
        String brokers = endpoint.getConfiguration().getBrokers();
        if (brokers == null) {
            brokers = endpoint.getComponent().getBrokers();
        }
        if (ObjectHelper.isEmpty((Object)brokers)) {
            throw new IllegalArgumentException("Brokers must be configured");
        }
        if (endpoint.getConfiguration().getGroupId() == null) {
            throw new IllegalArgumentException("groupId must not be null");
        }
    }

    Properties getProps() {
        Properties props = this.endpoint.getConfiguration().createConsumerProperties();
        this.endpoint.updateClassProperties(props);
        String brokers = this.endpoint.getConfiguration().getBrokers();
        if (brokers == null) {
            brokers = this.endpoint.getComponent().getBrokers();
        }
        props.put("bootstrap.servers", brokers);
        props.put("group.id", this.endpoint.getConfiguration().getGroupId());
        return props;
    }

    protected void doStart() throws Exception {
        this.log.info("Starting Kafka consumer on topic: {} with breakOnFirstError: {}", (Object)this.endpoint.getConfiguration().getTopic(), (Object)this.endpoint.getConfiguration().isBreakOnFirstError());
        super.doStart();
        this.executor = this.endpoint.createExecutor();
        for (int i = 0; i < this.endpoint.getConfiguration().getConsumersCount(); ++i) {
            KafkaFetchRecords task = new KafkaFetchRecords(this.endpoint.getConfiguration().getTopic(), i + "", this.getProps());
            this.executor.submit(task);
            this.tasks.add(task);
        }
    }

    protected void doStop() throws Exception {
        this.log.info("Stopping Kafka consumer on topic: {}", (Object)this.endpoint.getConfiguration().getTopic());
        if (this.executor != null) {
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownGraceful(this.executor);
            } else {
                this.executor.shutdownNow();
            }
            if (!this.executor.isTerminated()) {
                this.tasks.forEach(rec$ -> ((KafkaFetchRecords)rec$).shutdown());
                this.executor.shutdownNow();
            }
        }
        this.tasks.clear();
        this.executor = null;
        super.doStop();
    }

    protected String serializeOffsetKey(TopicPartition topicPartition) {
        return topicPartition.topic() + '/' + topicPartition.partition();
    }

    protected String serializeOffsetValue(long offset) {
        return String.valueOf(offset);
    }

    protected long deserializeOffsetValue(String offset) {
        return Long.parseLong(offset);
    }

    class KafkaFetchRecords
    implements Runnable {
        private org.apache.kafka.clients.consumer.KafkaConsumer consumer;
        private final String topicName;
        private final String threadId;
        private final Properties kafkaProps;

        KafkaFetchRecords(String topicName, String id, Properties kafkaProps) {
            this.topicName = topicName;
            this.threadId = topicName + "-Thread " + id;
            this.kafkaProps = kafkaProps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean first = true;
            boolean reConnect = true;
            while (reConnect) {
                ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(org.apache.kafka.clients.consumer.KafkaConsumer.class.getClassLoader());
                    this.consumer = new org.apache.kafka.clients.consumer.KafkaConsumer(this.kafkaProps);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(threadClassLoader);
                }
                if (!first) {
                    long delay = KafkaConsumer.this.endpoint.getConfiguration().getPollTimeoutMs();
                    KafkaConsumer.this.log.info("Reconnecting {} to topic {} after {} ms", new Object[]{this.threadId, this.topicName, delay});
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                first = false;
                reConnect = this.doRun();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean doRun() {
            boolean reConnect = false;
            try {
                KafkaConsumer.this.log.info("Subscribing {} to topic {}", (Object)this.threadId, (Object)this.topicName);
                this.consumer.subscribe(Arrays.asList(this.topicName.split(",")));
                StateRepository<String, String> offsetRepository = KafkaConsumer.this.endpoint.getConfiguration().getOffsetRepository();
                if (offsetRepository != null) {
                    ConsumerRecords poll = this.consumer.poll(100L);
                    for (TopicPartition topicPartition : this.consumer.assignment()) {
                        String offsetState = (String)offsetRepository.getState((Object)KafkaConsumer.this.serializeOffsetKey(topicPartition));
                        if (offsetState != null && !offsetState.isEmpty()) {
                            long offset = KafkaConsumer.this.deserializeOffsetValue(offsetState) + 1L;
                            KafkaConsumer.this.log.debug("Resuming partition {} from offset {} from state", (Object)topicPartition.partition(), (Object)offset);
                            this.consumer.seek(topicPartition, offset);
                            continue;
                        }
                        List partitionRecords = poll.records(topicPartition);
                        if (partitionRecords.isEmpty()) continue;
                        long offset = ((ConsumerRecord)partitionRecords.get(0)).offset();
                        KafkaConsumer.this.log.debug("Resuming partition {} from offset {}", (Object)topicPartition.partition(), (Object)offset);
                        this.consumer.seek(topicPartition, offset);
                    }
                } else if (KafkaConsumer.this.endpoint.getConfiguration().getSeekTo() != null) {
                    if (KafkaConsumer.this.endpoint.getConfiguration().getSeekTo().equals("beginning")) {
                        KafkaConsumer.this.log.debug("{} is seeking to the beginning on topic {}", (Object)this.threadId, (Object)this.topicName);
                        this.consumer.poll(100L);
                        this.consumer.seekToBeginning((Collection)this.consumer.assignment());
                    } else if (KafkaConsumer.this.endpoint.getConfiguration().getSeekTo().equals("end")) {
                        KafkaConsumer.this.log.debug("{} is seeking to the end on topic {}", (Object)this.threadId, (Object)this.topicName);
                        this.consumer.poll(100L);
                        this.consumer.seekToEnd((Collection)this.consumer.assignment());
                    }
                }
                while (KafkaConsumer.this.isRunAllowed() && !reConnect && !KafkaConsumer.this.isStoppingOrStopped() && !KafkaConsumer.this.isSuspendingOrSuspended()) {
                    boolean breakOnErrorHit = false;
                    KafkaConsumer.this.log.trace("Polling {} from topic: {} with timeout: {}", new Object[]{this.threadId, this.topicName, KafkaConsumer.this.pollTimeoutMs});
                    ConsumerRecords allRecords = this.consumer.poll(KafkaConsumer.this.pollTimeoutMs.longValue());
                    for (TopicPartition partition : allRecords.partitions()) {
                        long partitionLastOffset = -1L;
                        Iterator recordIterator = allRecords.records(partition).iterator();
                        if (breakOnErrorHit || !recordIterator.hasNext()) continue;
                        while (!breakOnErrorHit && recordIterator.hasNext()) {
                            ConsumerRecord record = (ConsumerRecord)recordIterator.next();
                            if (KafkaConsumer.this.log.isTraceEnabled()) {
                                KafkaConsumer.this.log.trace("Partition = {}, offset = {}, key = {}, value = {}", new Object[]{record.partition(), record.offset(), record.key(), record.value()});
                            }
                            Exchange exchange = KafkaConsumer.this.endpoint.createKafkaExchange(record);
                            if (KafkaConsumer.this.endpoint.getConfiguration().isAutoCommitEnable() != null && !KafkaConsumer.this.endpoint.getConfiguration().isAutoCommitEnable().booleanValue()) {
                                exchange.getIn().setHeader("kafka.LAST_RECORD_BEFORE_COMMIT", (Object)(!recordIterator.hasNext() ? 1 : 0));
                            }
                            try {
                                KafkaConsumer.this.processor.process(exchange);
                            }
                            catch (Exception e) {
                                exchange.setException((Throwable)e);
                            }
                            if (exchange.getException() != null) {
                                if (KafkaConsumer.this.endpoint.getConfiguration().isBreakOnFirstError()) {
                                    KafkaConsumer.this.log.warn("Error during processing {} from topic: {}. Will seek consumer to offset: {} and re-connect and start polling again.", new Object[]{exchange, this.topicName, partitionLastOffset});
                                    this.commitOffset(offsetRepository, partition, partitionLastOffset, true);
                                    breakOnErrorHit = true;
                                    continue;
                                }
                                KafkaConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)exchange.getException());
                                continue;
                            }
                            partitionLastOffset = record.offset();
                        }
                        if (breakOnErrorHit) continue;
                        this.commitOffset(offsetRepository, partition, partitionLastOffset, false);
                    }
                    if (!breakOnErrorHit) continue;
                    reConnect = true;
                }
                if (!reConnect && KafkaConsumer.this.endpoint.getConfiguration().isAutoCommitEnable() != null && KafkaConsumer.this.endpoint.getConfiguration().isAutoCommitEnable().booleanValue()) {
                    if ("async".equals(KafkaConsumer.this.endpoint.getConfiguration().getAutoCommitOnStop())) {
                        KafkaConsumer.this.log.info("Auto commitAsync on stop {} from topic {}", (Object)this.threadId, (Object)this.topicName);
                        this.consumer.commitAsync();
                    } else if ("sync".equals(KafkaConsumer.this.endpoint.getConfiguration().getAutoCommitOnStop())) {
                        KafkaConsumer.this.log.info("Auto commitSync on stop {} from topic {}", (Object)this.threadId, (Object)this.topicName);
                        this.consumer.commitSync();
                    }
                }
                KafkaConsumer.this.log.info("Unsubscribing {} from topic {}", (Object)this.threadId, (Object)this.topicName);
                this.consumer.unsubscribe();
            }
            catch (InterruptException e) {
                KafkaConsumer.this.getExceptionHandler().handleException("Interrupted while consuming " + this.threadId + " from kafka topic", (Throwable)e);
                KafkaConsumer.this.log.info("Unsubscribing {} from topic {}", (Object)this.threadId, (Object)this.topicName);
                this.consumer.unsubscribe();
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                KafkaConsumer.this.getExceptionHandler().handleException("Error consuming " + this.threadId + " from kafka topic", (Throwable)e);
            }
            finally {
                KafkaConsumer.this.log.debug("Closing {} ", (Object)this.threadId);
                IOHelper.close((Closeable)this.consumer);
            }
            return reConnect;
        }

        private void commitOffset(StateRepository<String, String> offsetRepository, TopicPartition partition, long partitionLastOffset, boolean forceCommit) {
            if (partitionLastOffset != -1L) {
                if (offsetRepository != null) {
                    offsetRepository.setState((Object)KafkaConsumer.this.serializeOffsetKey(partition), (Object)KafkaConsumer.this.serializeOffsetValue(partitionLastOffset));
                } else if (forceCommit) {
                    KafkaConsumer.this.log.debug("Forcing commitSync {} from topic {} with offset: {}", new Object[]{this.threadId, this.topicName, partitionLastOffset});
                    this.consumer.commitSync(Collections.singletonMap(partition, new OffsetAndMetadata(partitionLastOffset + 1L)));
                } else if (KafkaConsumer.this.endpoint.getConfiguration().isAutoCommitEnable() != null && !KafkaConsumer.this.endpoint.getConfiguration().isAutoCommitEnable().booleanValue()) {
                    KafkaConsumer.this.log.debug("Auto commitSync {} from topic {} with offset: {}", new Object[]{this.threadId, this.topicName, partitionLastOffset});
                    this.consumer.commitSync(Collections.singletonMap(partition, new OffsetAndMetadata(partitionLastOffset + 1L)));
                }
            }
        }

        private void shutdown() {
            this.consumer.wakeup();
        }
    }
}

