/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.common;

import com.bazaarvoice.jolt.common.SpecStringParser;
import com.bazaarvoice.jolt.common.pathelement.AmpPathElement;
import com.bazaarvoice.jolt.common.pathelement.ArrayPathElement;
import com.bazaarvoice.jolt.common.pathelement.AtPathElement;
import com.bazaarvoice.jolt.common.pathelement.DollarPathElement;
import com.bazaarvoice.jolt.common.pathelement.HashPathElement;
import com.bazaarvoice.jolt.common.pathelement.LiteralPathElement;
import com.bazaarvoice.jolt.common.pathelement.MatchablePathElement;
import com.bazaarvoice.jolt.common.pathelement.PathElement;
import com.bazaarvoice.jolt.common.pathelement.StarAllPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarDoublePathElement;
import com.bazaarvoice.jolt.common.pathelement.StarRegexPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarSinglePathElement;
import com.bazaarvoice.jolt.common.pathelement.TransposePathElement;
import com.bazaarvoice.jolt.exception.SpecException;
import com.bazaarvoice.jolt.utils.StringTools;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class PathElementBuilder {
    private PathElementBuilder() {
    }

    public static MatchablePathElement buildMatchablePathElement(String rawJsonKey) {
        PathElement pe = PathElementBuilder.parseSingleKeyLHS(rawJsonKey);
        if (!(pe instanceof MatchablePathElement)) {
            throw new SpecException("Spec LHS key=" + rawJsonKey + " is not a valid LHS key.");
        }
        return (MatchablePathElement)pe;
    }

    public static PathElement parseSingleKeyLHS(String origKey) {
        String elementKey;
        String keyToInspect;
        if (origKey.contains("\\")) {
            keyToInspect = SpecStringParser.removeEscapedValues(origKey);
            elementKey = SpecStringParser.removeEscapeChars(origKey);
        } else {
            keyToInspect = origKey;
            elementKey = origKey;
        }
        if ("@".equals(keyToInspect)) {
            return new AtPathElement(elementKey);
        }
        if ("*".equals(keyToInspect)) {
            return new StarAllPathElement(elementKey);
        }
        if (keyToInspect.startsWith("[")) {
            if (StringTools.countMatches(keyToInspect, "[") != 1 || StringTools.countMatches(keyToInspect, "]") != 1) {
                throw new SpecException("Invalid key:" + origKey + " has too many [] references.");
            }
            return new ArrayPathElement(elementKey);
        }
        if (keyToInspect.startsWith("@") || keyToInspect.contains("@(")) {
            return TransposePathElement.parse(origKey);
        }
        if (keyToInspect.contains("@")) {
            throw new SpecException("Invalid key:" + origKey + " can not have an @ other than at the front.");
        }
        if (keyToInspect.contains("$")) {
            return new DollarPathElement(elementKey);
        }
        if (keyToInspect.contains("[")) {
            if (StringTools.countMatches(keyToInspect, "[") != 1 || StringTools.countMatches(keyToInspect, "]") != 1) {
                throw new SpecException("Invalid key:" + origKey + " has too many [] references.");
            }
            return new ArrayPathElement(elementKey);
        }
        if (keyToInspect.contains("&")) {
            if (keyToInspect.contains("*")) {
                throw new SpecException("Invalid key:" + origKey + ", Can't mix * with & ) ");
            }
            return new AmpPathElement(elementKey);
        }
        if (keyToInspect.contains("*")) {
            int numOfStars = StringTools.countMatches(keyToInspect, "*");
            if (numOfStars == 1) {
                return new StarSinglePathElement(elementKey);
            }
            if (numOfStars == 2) {
                return new StarDoublePathElement(elementKey);
            }
            return new StarRegexPathElement(elementKey);
        }
        if (keyToInspect.contains("#")) {
            return new HashPathElement(elementKey);
        }
        return new LiteralPathElement(elementKey);
    }

    public static List<PathElement> parseDotNotationRHS(String dotNotation) {
        String fixedNotation = SpecStringParser.fixLeadingBracketSugar(dotNotation);
        List<String> pathStrs = SpecStringParser.parseDotNotation(new LinkedList<String>(), SpecStringParser.stringIterator(fixedNotation), dotNotation);
        return PathElementBuilder.parseList(pathStrs, dotNotation);
    }

    public static List<PathElement> parseList(List<String> keys, String refDotNotation) {
        ArrayList<PathElement> paths = new ArrayList<PathElement>();
        for (String key : keys) {
            PathElement path = PathElementBuilder.parseSingleKeyLHS(key);
            if (path instanceof AtPathElement) {
                throw new SpecException("'.@.' is not valid on the RHS: " + refDotNotation);
            }
            paths.add(path);
        }
        return paths;
    }
}

