/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.common;

import com.bazaarvoice.jolt.exception.SpecException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class SpecStringParser {
    private SpecStringParser() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static List<String> parseDotNotation(List<String> pathStrings, Iterator<Character> iter, String dotNotationRef) {
        if (!iter.hasNext()) {
            return pathStrings;
        }
        boolean prevIsEscape = false;
        boolean currIsEscape = false;
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            block14: {
                char c = iter.next().charValue();
                currIsEscape = false;
                if (c == '\\' && !prevIsEscape) {
                    currIsEscape = true;
                }
                if (prevIsEscape && c != '.' && c != '\\') {
                    sb.append('\\');
                    sb.append(c);
                } else if (c == '@') {
                    boolean isPartOfArray;
                    sb.append('@');
                    sb.append(SpecStringParser.parseAtPathElement(iter, dotNotationRef));
                    boolean bl = isPartOfArray = sb.indexOf("[") != -1 && sb.indexOf("]") == -1;
                    if (!isPartOfArray) {
                        pathStrings.add(sb.toString());
                        sb = new StringBuilder();
                    }
                } else {
                    if (c == '.') {
                        if (prevIsEscape) {
                            sb.append('.');
                            break block14;
                        } else {
                            if (sb.length() != 0) {
                                pathStrings.add(sb.toString());
                            }
                            return SpecStringParser.parseDotNotation(pathStrings, iter, dotNotationRef);
                        }
                    }
                    if (!currIsEscape) {
                        sb.append(c);
                    }
                }
            }
            prevIsEscape = currIsEscape;
        }
        if (sb.length() != 0) {
            pathStrings.add(sb.toString());
        }
        return pathStrings;
    }

    public static Iterator<Character> stringIterator(final String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return new Iterator<Character>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < string.length();
            }

            @Override
            public Character next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Character.valueOf(string.charAt(this.index++));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static String fixLeadingBracketSugar(String dotNotaton) {
        if (dotNotaton == null || dotNotaton.length() == 0) {
            return "";
        }
        char prev = dotNotaton.charAt(0);
        StringBuilder sb = new StringBuilder();
        sb.append(prev);
        for (int index = 1; index < dotNotaton.length(); ++index) {
            char curr = dotNotaton.charAt(index);
            if (curr == '[' && prev != '\\' && prev != '@' && prev != '.') {
                sb.append('.');
            }
            sb.append(curr);
            prev = curr;
        }
        return sb.toString();
    }

    public static String parseAtPathElement(Iterator<Character> iter, String dotNotationRef) {
        if (!iter.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean isParensAt = false;
        int atParensCount = 0;
        char c = iter.next().charValue();
        if (c == '(') {
            isParensAt = true;
            ++atParensCount;
        } else if (c == '.') {
            throw new SpecException("Unable to parse dotNotation, invalid TransposePathElement : " + dotNotationRef);
        }
        sb.append(c);
        while (iter.hasNext()) {
            c = iter.next().charValue();
            sb.append(c);
            if (isParensAt) {
                if (c == '(') {
                    throw new SpecException("Unable to parse dotNotation, too many open parens '(' : " + dotNotationRef);
                }
                if (c == ')') {
                    --atParensCount;
                }
                if (atParensCount == 0) {
                    return sb.toString();
                }
                if (atParensCount >= 0) continue;
                throw new SpecException("Unable to parse dotNotation, specifically the '@()' part : " + dotNotationRef);
            }
            if (c != '.') continue;
            return "(" + sb.toString().substring(0, sb.length() - 1) + ")";
        }
        if (isParensAt && atParensCount != 0) {
            throw new SpecException("Invalid @() pathElement from : " + dotNotationRef);
        }
        return sb.toString();
    }

    public static String removeEscapedValues(String origKey) {
        StringBuilder sb = new StringBuilder();
        boolean prevWasEscape = false;
        for (char c : origKey.toCharArray()) {
            if ('\\' == c) {
                if (prevWasEscape) {
                    prevWasEscape = false;
                    continue;
                }
                prevWasEscape = true;
                continue;
            }
            if (!prevWasEscape) {
                sb.append(c);
            }
            prevWasEscape = false;
        }
        return sb.toString();
    }

    public static String removeEscapeChars(String origKey) {
        StringBuilder sb = new StringBuilder();
        boolean prevWasEscape = false;
        for (char c : origKey.toCharArray()) {
            if ('\\' == c) {
                if (prevWasEscape) {
                    sb.append(c);
                    prevWasEscape = false;
                    continue;
                }
                prevWasEscape = true;
                continue;
            }
            sb.append(c);
            prevWasEscape = false;
        }
        return sb.toString();
    }

    public static List<String> parseFunctionArgs(String argString) {
        LinkedList<String> argsList = new LinkedList<String>();
        int firstBracket = argString.indexOf(40);
        String className = argString.substring(0, firstBracket);
        argsList.add(className);
        argString = argString.substring(firstBracket + 1, argString.length() - 1);
        StringBuilder sb = new StringBuilder();
        boolean inBetweenBrackets = false;
        boolean inBetweenQuotes = false;
        block6: for (int i = 0; i < argString.length(); ++i) {
            char c = argString.charAt(i);
            switch (c) {
                case '(': {
                    inBetweenBrackets = true;
                    sb.append(c);
                    continue block6;
                }
                case ')': {
                    inBetweenBrackets = false;
                    sb.append(c);
                    continue block6;
                }
                case '\'': {
                    inBetweenQuotes = !inBetweenQuotes;
                    sb.append(c);
                    continue block6;
                }
                case ',': {
                    if (!inBetweenBrackets && !inBetweenQuotes) {
                        argsList.add(sb.toString().trim());
                        sb = new StringBuilder();
                        continue block6;
                    }
                }
                default: {
                    sb.append(c);
                }
            }
        }
        argsList.add(sb.toString().trim());
        return argsList;
    }
}

