/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.modifier.spec;

import com.bazaarvoice.jolt.common.Optional;
import com.bazaarvoice.jolt.common.PathElementBuilder;
import com.bazaarvoice.jolt.common.PathEvaluatingTraversal;
import com.bazaarvoice.jolt.common.TransposeReader;
import com.bazaarvoice.jolt.common.TraversalBuilder;
import com.bazaarvoice.jolt.common.pathelement.ArrayPathElement;
import com.bazaarvoice.jolt.common.pathelement.LiteralPathElement;
import com.bazaarvoice.jolt.common.pathelement.MatchablePathElement;
import com.bazaarvoice.jolt.common.pathelement.StarPathElement;
import com.bazaarvoice.jolt.common.spec.BaseSpec;
import com.bazaarvoice.jolt.common.tree.ArrayMatchedElement;
import com.bazaarvoice.jolt.common.tree.MatchedElement;
import com.bazaarvoice.jolt.common.tree.WalkedPath;
import com.bazaarvoice.jolt.exception.SpecException;
import com.bazaarvoice.jolt.exception.TransformException;
import com.bazaarvoice.jolt.modifier.OpMode;
import java.util.List;
import java.util.Map;

public abstract class ModifierSpec
implements BaseSpec {
    protected static final TraversalBuilder TRAVERSAL_BUILDER = new TraversalBuilder(){

        @Override
        public <T extends PathEvaluatingTraversal> T buildFromPath(String path) {
            return (T)new TransposeReader(path);
        }
    };
    protected final OpMode opMode;
    protected final MatchablePathElement pathElement;
    protected final boolean checkValue;

    protected ModifierSpec(String rawJsonKey, OpMode opMode) {
        String suffix;
        String prefix = rawJsonKey.substring(0, 1);
        String string = suffix = rawJsonKey.length() > 1 ? rawJsonKey.substring(rawJsonKey.length() - 1) : null;
        if (OpMode.isValid(prefix)) {
            this.opMode = OpMode.from(prefix);
            rawJsonKey = rawJsonKey.substring(1);
        } else {
            this.opMode = opMode;
        }
        if (suffix != null && suffix.equals("?") && !rawJsonKey.endsWith("\\?")) {
            this.checkValue = true;
            rawJsonKey = rawJsonKey.substring(0, rawJsonKey.length() - 1);
        } else {
            this.checkValue = false;
        }
        this.pathElement = PathElementBuilder.buildMatchablePathElement(rawJsonKey);
        if (!(this.pathElement instanceof StarPathElement || this.pathElement instanceof LiteralPathElement || this.pathElement instanceof ArrayPathElement)) {
            throw new SpecException(opMode.name() + " cannot have " + this.pathElement.getClass().getSimpleName() + " RHS");
        }
    }

    @Override
    public MatchablePathElement getPathElement() {
        return this.pathElement;
    }

    @Override
    public boolean apply(String inputKey, Optional<Object> inputOptional, WalkedPath walkedPath, Map<String, Object> output, Map<String, Object> context) {
        if (output != null) {
            throw new TransformException("Expected a null output");
        }
        MatchedElement thisLevel = this.pathElement.match(inputKey, walkedPath);
        if (thisLevel == null) {
            return false;
        }
        if (!this.checkValue) {
            this.applyElement(inputKey, inputOptional, thisLevel, walkedPath, context);
        } else if (inputOptional.isPresent()) {
            this.applyElement(inputKey, inputOptional, thisLevel, walkedPath, context);
        }
        return true;
    }

    protected abstract void applyElement(String var1, Optional<Object> var2, MatchedElement var3, WalkedPath var4, Map<String, Object> var5);

    protected static void setData(Object parent, MatchedElement matchedElement, Object value, OpMode opMode) {
        if (parent instanceof Map) {
            Map source = (Map)parent;
            String key = matchedElement.getRawKey();
            if (opMode.isApplicable(source, key)) {
                source.put(key, value);
            }
        } else if (parent instanceof List && matchedElement instanceof ArrayMatchedElement) {
            List source = (List)parent;
            int origSize = ((ArrayMatchedElement)matchedElement).getOrigSize();
            int reqIndex = ((ArrayMatchedElement)matchedElement).getRawIndex();
            if (opMode.isApplicable(source, reqIndex, origSize)) {
                source.set(reqIndex, value);
            }
        } else {
            throw new RuntimeException("Should not come here!");
        }
    }
}

