/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.traversr;

import com.bazaarvoice.jolt.common.Optional;
import com.bazaarvoice.jolt.traversr.SimpleTraversr;
import java.util.Arrays;
import java.util.List;

public class SimpleTraversal<DataType> {
    private final SimpleTraversr traversr;
    private final List<String> keys;

    public static <T> SimpleTraversal<T> newTraversal(String humanReadablePath) {
        return new SimpleTraversal(humanReadablePath);
    }

    public SimpleTraversal(String humanReadablePath) {
        this.traversr = new SimpleTraversr(humanReadablePath);
        String[] keysArray = humanReadablePath.split("\\.");
        for (int index = 0; index < keysArray.length; ++index) {
            String key = keysArray[index];
            if (key.charAt(0) != '[' || key.charAt(key.length() - 1) != ']' || key.length() <= 2) continue;
            keysArray[index] = key.substring(1, key.length() - 1);
        }
        this.keys = Arrays.asList(keysArray);
    }

    public Optional<DataType> get(Object tree) {
        return this.traversr.get(tree, this.keys);
    }

    public Optional<DataType> set(Object tree, DataType data) {
        return this.traversr.set(tree, this.keys, data);
    }

    public Optional<DataType> remove(Object tree) {
        return this.traversr.remove(tree, this.keys);
    }
}

