/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JoltUtils {
    public static void removeRecursive(Object json, String keyToRemove) {
        if (json == null || keyToRemove == null) {
            return;
        }
        if (json instanceof Map) {
            Map jsonMap = (Map)JoltUtils.cast(json);
            if (jsonMap.containsKey(keyToRemove)) {
                jsonMap.remove(keyToRemove);
            }
            for (Object value : jsonMap.values()) {
                JoltUtils.removeRecursive(value, keyToRemove);
            }
        }
        if (json instanceof List) {
            for (Object value : (List)json) {
                JoltUtils.removeRecursive(value, keyToRemove);
            }
        }
    }

    public static <T> T navigate(Object source, Object ... paths) {
        Object destination = source;
        for (Object path : paths) {
            if (path == null || destination == null) {
                throw new NullPointerException("source or path is null");
            }
            if (destination instanceof Map) {
                destination = ((Map)destination).get(path);
                continue;
            }
            if (path instanceof Integer && destination instanceof List) {
                destination = ((List)destination).get((Integer)path);
                continue;
            }
            throw new UnsupportedOperationException("Navigation supports only Map and List source types and non-null String and Integer path types");
        }
        return JoltUtils.cast(destination);
    }

    public static <T> T navigateSafe(T defaultValue, Object source, Object ... paths) {
        Object destination = source;
        for (Object path : paths) {
            if (path == null || destination == null) {
                return defaultValue;
            }
            if (destination instanceof Map) {
                Map destinationMap = (Map)destination;
                if (!destinationMap.containsKey(path)) {
                    return defaultValue;
                }
                destination = destinationMap.get(path);
                continue;
            }
            if (path instanceof Integer && destination instanceof List) {
                List destinationList = (List)destination;
                if ((Integer)path >= destinationList.size()) {
                    return defaultValue;
                }
                destination = destinationList.get((Integer)path);
                continue;
            }
            throw new UnsupportedOperationException("Navigation supports only Map and List source types and non-null String and Integer path types");
        }
        return JoltUtils.cast(destination);
    }

    @Deprecated
    public static boolean isEmptyJson(Object obj) {
        return JoltUtils.isVacantJson(obj);
    }

    public static boolean isVacantJson(Object obj) {
        Collection values = null;
        if (obj instanceof Collection) {
            if (((Collection)obj).size() == 0) {
                return true;
            }
            values = (Collection)obj;
        }
        if (obj instanceof Map) {
            if (((Map)obj).size() == 0) {
                return true;
            }
            values = ((Map)obj).values();
        }
        int processedEmpty = 0;
        if (values != null) {
            for (Object value : values) {
                if (!JoltUtils.isVacantJson(value)) {
                    return false;
                }
                ++processedEmpty;
            }
            if (processedEmpty == values.size()) {
                return true;
            }
        }
        return false;
    }

    public static boolean isBlankJson(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size() == 0;
        }
        if (obj instanceof Map) {
            return ((Map)obj).size() == 0;
        }
        throw new UnsupportedOperationException("map or list is supported, got ${obj?obj.getClass():null}");
    }

    public static List<Object[]> listKeyChains(Object source) {
        LinkedList<Object[]> keyChainList = new LinkedList<Object[]>();
        if (source instanceof Map) {
            Map sourceMap = (Map)source;
            for (Object key : sourceMap.keySet()) {
                keyChainList.addAll(JoltUtils.listKeyChains(key, sourceMap.get(key)));
            }
        } else if (source instanceof List) {
            List sourceList = (List)source;
            for (int i = 0; i < sourceList.size(); ++i) {
                keyChainList.addAll(JoltUtils.listKeyChains(i, sourceList.get(i)));
            }
        } else {
            return Collections.emptyList();
        }
        return keyChainList;
    }

    public static List<Object[]> listKeyChains(Object key, Object value) {
        LinkedList<Object[]> keyChainList = new LinkedList<Object[]>();
        List<Object[]> childKeyChainList = JoltUtils.listKeyChains(value);
        if (childKeyChainList.size() > 0) {
            for (Object[] childKeyChain : childKeyChainList) {
                Object[] keyChain = new Object[childKeyChain.length + 1];
                keyChain[0] = key;
                System.arraycopy(childKeyChain, 0, keyChain, 1, childKeyChain.length);
                keyChainList.add(keyChain);
            }
        } else {
            keyChainList.add(new Object[]{key});
        }
        return keyChainList;
    }

    public static String toSimpleTraversrPath(Object[] paths) {
        StringBuilder pathBuilder = new StringBuilder();
        for (int i = 0; i < paths.length; ++i) {
            Object path = paths[i];
            if (path instanceof Integer) {
                pathBuilder.append("[").append((Integer)path).append("]");
            } else if (path instanceof String) {
                pathBuilder.append(path.toString());
            } else {
                throw new UnsupportedOperationException("Only Strings and Integers are supported as path element");
            }
            if (i + 1 == paths.length) continue;
            pathBuilder.append(".");
        }
        return pathBuilder.toString();
    }

    public static <T> T cast(Object object) {
        return (T)object;
    }

    public static <E> E[] cast(Object[] object) {
        return object;
    }

    public static Object compactJson(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof List) {
            for (Object item : (List)source) {
                if (item instanceof List) {
                    JoltUtils.compactJson(item);
                    continue;
                }
                if (!(item instanceof Map)) continue;
                JoltUtils.compactJson(item);
            }
            ((List)source).removeAll(Collections.singleton(null));
        } else if (source instanceof Map) {
            LinkedList keysToRemove = new LinkedList();
            for (Object key : ((Map)source).keySet()) {
                Object value = ((Map)source).get(key);
                if (value instanceof List) {
                    if (((List)value).size() == 0) {
                        keysToRemove.add(key);
                        continue;
                    }
                    JoltUtils.compactJson(value);
                    continue;
                }
                if (value instanceof Map) {
                    if (((Map)value).size() == 0) {
                        keysToRemove.add(key);
                        continue;
                    }
                    JoltUtils.compactJson(value);
                    continue;
                }
                if (value != null) continue;
                keysToRemove.add(key);
            }
            for (Object key : keysToRemove) {
                ((Map)source).remove(key);
            }
        } else {
            throw new UnsupportedOperationException("Only Map/String and List/Integer types are supported");
        }
        return source;
    }

    public static <T> T store(Object source, T value, Object ... paths) {
        int destKeyIndex = paths.length - 1;
        if (destKeyIndex < 0) {
            throw new IllegalArgumentException("No path information provided");
        }
        if (source == null) {
            throw new NullPointerException("source cannot be null");
        }
        for (int i = 0; i < destKeyIndex; ++i) {
            Object currentPath = paths[i];
            Object nextPath = paths[i + 1];
            source = JoltUtils.getOrCreateNextObject(source, currentPath, nextPath);
        }
        Object path = paths[destKeyIndex];
        if (source instanceof Map && path instanceof String) {
            return JoltUtils.cast(((Map)source).put(path, value));
        }
        if (source instanceof List && path instanceof Integer) {
            JoltUtils.ensureListAvailability((List)source, (Integer)path);
            return JoltUtils.cast(((List)source).set((Integer)path, value));
        }
        throw new UnsupportedOperationException("Only Map/String and List/Integer types are supported");
    }

    public static <T> T remove(Object source, Object ... paths) {
        int destKeyIndex = paths.length - 1;
        if (destKeyIndex < 0) {
            throw new IllegalArgumentException("No path information provided");
        }
        if (source == null) {
            throw new NullPointerException("source cannot be null");
        }
        for (int i = 0; i < destKeyIndex; ++i) {
            Object currentPath = paths[i];
            Object nextPath = paths[i + 1];
            source = JoltUtils.getOrCreateNextObject(source, currentPath, nextPath);
        }
        Object path = paths[destKeyIndex];
        if (source instanceof Map && path instanceof String) {
            return JoltUtils.cast(((Map)source).remove(path));
        }
        if (source instanceof List && path instanceof Integer) {
            JoltUtils.ensureListAvailability((List)source, (Integer)path);
            return JoltUtils.cast(((List)source).remove((Integer)path));
        }
        throw new UnsupportedOperationException("Only Map/String and List/Integer types are supported");
    }

    private static void ensureListAvailability(List source, int index) {
        for (int i = source.size(); i <= index; ++i) {
            source.add(i, null);
        }
    }

    private static Object getOrCreateNextObject(Object source, Object key, Object nextKey) {
        Object value;
        if (source instanceof Map && key instanceof String) {
            value = ((Map)source).get(key);
            if (value == null) {
                Cloneable newValue;
                if (nextKey instanceof String) {
                    newValue = new HashMap();
                } else if (nextKey instanceof Integer) {
                    newValue = new LinkedList();
                } else {
                    throw new UnsupportedOperationException("Only String and Integer types are supported");
                }
                ((Map)source).put(key, newValue);
                value = newValue;
            }
        } else if (source instanceof List && key instanceof Integer) {
            JoltUtils.ensureListAvailability((List)source, (Integer)key);
            value = ((List)source).get((Integer)key);
            if (value == null) {
                Cloneable newValue;
                if (nextKey instanceof String) {
                    newValue = new HashMap();
                } else if (nextKey instanceof Integer) {
                    newValue = new LinkedList();
                } else {
                    throw new UnsupportedOperationException("Only String and Integer types are supported");
                }
                ((List)source).set((Integer)key, newValue);
                value = newValue;
            }
        } else {
            if (source == null || key == null) {
                throw new NullPointerException("source and/or key cannot be null");
            }
            throw new UnsupportedOperationException("Only Map and List types are supported");
        }
        if (nextKey instanceof String && value instanceof Map || nextKey instanceof Integer && value instanceof List) {
            return value;
        }
        throw new UnsupportedOperationException("Only Map/String and List/Integer types are supported");
    }
}

