/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.activex.javascript.msxml;

import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMNode;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMNodeList;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMText;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.lang3.StringUtils;

@JsxClass(domClass=DomAttr.class, browsers={@WebBrowser(value=BrowserName.IE)})
public class XMLDOMAttribute
extends XMLDOMNode {
    private XMLDOMText textNode_;

    @Override
    public XMLDOMNodeList getChildNodes() {
        this.initTextNode();
        return super.getChildNodes();
    }

    @Override
    public XMLDOMNode getFirstChild() {
        return this.getLastChild();
    }

    @Override
    public XMLDOMNode getLastChild() {
        this.initTextNode();
        return this.textNode_;
    }

    private void initTextNode() {
        String value;
        if (this.textNode_ == null && !StringUtils.isEmpty((CharSequence)(value = this.getValue()))) {
            DomText text = new DomText(this.getDomNodeOrDie().getPage(), value);
            this.getDomNodeOrDie().appendChild(text);
            this.textNode_ = (XMLDOMText)text.getScriptableObject();
        }
    }

    @JsxGetter
    public String getName() {
        return this.getDomNodeOrDie().getName();
    }

    @Override
    public String getNodeValue() {
        return this.getValue();
    }

    @Override
    public void setNodeValue(String value) {
        this.setValue(value);
    }

    @Override
    public Node getParentNode() {
        return null;
    }

    @JsxGetter
    public boolean getSpecified() {
        return this.getDomNodeOrDie().getSpecified();
    }

    @Override
    public Object getText() {
        return this.getValue();
    }

    @Override
    public void setText(Object value) {
        this.setValue(value == null ? null : Context.toString((Object)value));
    }

    @JsxGetter
    public String getValue() {
        return this.getDomNodeOrDie().getValue();
    }

    @JsxSetter
    public void setValue(String value) {
        this.getDomNodeOrDie().setValue(value);
        this.resetTextNode();
    }

    private void resetTextNode() {
        if (this.textNode_ != null) {
            this.getDomNodeOrDie().removeChild(this.textNode_.getDomNodeOrNull());
            this.textNode_ = null;
        }
    }

    @Override
    public String getXml() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append('=').append('\"');
        sb.append(com.gargoylesoftware.htmlunit.util.StringUtils.escapeXmlAttributeValue(this.getValue()));
        sb.append('\"');
        return sb.toString();
    }

    public void detachFromParent() {
        DomAttr domNode = this.getDomNodeOrDie();
        DomElement parent = (DomElement)domNode.getParentNode();
        if (parent != null) {
            domNode.setValue(parent.getAttribute(this.getName()));
        }
        domNode.remove();
    }

    @Override
    public DomAttr getDomNodeOrDie() {
        return (DomAttr)super.getDomNodeOrDie();
    }
}

