/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.concurrent.CountDownLatch;
import kafka.api.FetchRequest;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.api.FetchResponsePartitionData;
import kafka.api.FetchResponsePartitionData$;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MessageSet$;
import kafka.tools.ReplicaBuffer;
import kafka.tools.ReplicaVerificationTool$;
import kafka.utils.ShutdownableThread;
import kafka.utils.ShutdownableThread$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0001\u0002\u0005\u000f\tq!+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014(BA\u0002\u0005\u0003\u0015!xn\u001c7t\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q!a\u0003\u0003\u0002\u000bU$\u0018\u000e\\:\n\u00055Q!AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012D\u0011b\u0004\u0001\u0003\u0002\u0003\u0006I\u0001\u0005\u000e\u0002\t9\fW.\u001a\t\u0003#]q!AE\u000b\u000e\u0003MQ\u0011\u0001F\u0001\u0006g\u000e\fG.Y\u0005\u0003-M\ta\u0001\u0015:fI\u00164\u0017B\u0001\r\u001a\u0005\u0019\u0019FO]5oO*\u0011acE\u0005\u0003\u001f1A\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!H\u0001\rg>,(oY3Ce>\\WM\u001d\t\u0003=\u0005j\u0011a\b\u0006\u0003A\u0011\tqa\u00197vgR,'/\u0003\u0002#?\tq!I]8lKJ,e\u000e\u001a)pS:$\b\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002%Q|\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|gn\u001d\t\u0004M9\ndBA\u0014-\u001d\tA3&D\u0001*\u0015\tQc!\u0001\u0004=e>|GOP\u0005\u0002)%\u0011QfE\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0003G\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\ti3\u0003\u0005\u00023k5\t1G\u0003\u00025\t\u000511m\\7n_:L!AN\u001a\u0003#Q{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u00035\u0011X\r\u001d7jG\u0006\u0014UO\u001a4feB\u0011!hO\u0007\u0002\u0005%\u0011AH\u0001\u0002\u000e%\u0016\u0004H.[2b\u0005V4g-\u001a:\t\u0011y\u0002!\u0011!Q\u0001\n}\nQb]8dW\u0016$H+[7f_V$\bC\u0001\nA\u0013\t\t5CA\u0002J]RD\u0001b\u0011\u0001\u0003\u0002\u0003\u0006IaP\u0001\u0011g>\u001c7.\u001a;Ck\u001a4WM]*ju\u0016D\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IaP\u0001\nM\u0016$8\r[*ju\u0016D\u0001b\u0012\u0001\u0003\u0002\u0003\u0006IaP\u0001\b[\u0006Dx+Y5u\u0011!I\u0005A!A!\u0002\u0013y\u0014\u0001C7j]\nKH/Z:\t\u0011-\u0003!\u0011!Q\u0001\n1\u000ba\u0002Z8WKJLg-[2bi&|g\u000e\u0005\u0002\u0013\u001b&\u0011aj\u0005\u0002\b\u0005>|G.Z1o\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0003\u0019a\u0014N\\5u}QY!k\u0015+V-^C\u0016LW.]!\tQ\u0004\u0001C\u0003\u0010\u001f\u0002\u0007\u0001\u0003C\u0003\u001d\u001f\u0002\u0007Q\u0004C\u0003%\u001f\u0002\u0007Q\u0005C\u00039\u001f\u0002\u0007\u0011\bC\u0003?\u001f\u0002\u0007q\bC\u0003D\u001f\u0002\u0007q\bC\u0003F\u001f\u0002\u0007q\bC\u0003H\u001f\u0002\u0007q\bC\u0003J\u001f\u0002\u0007q\bC\u0003L\u001f\u0002\u0007A\nC\u0004_\u0001\t\u0007I\u0011A0\u0002\u001dMLW\u000e\u001d7f\u0007>t7/^7feV\t\u0001\r\u0005\u0002bI6\t!M\u0003\u0002d\t\u0005A1m\u001c8tk6,'/\u0003\u0002fE\nq1+[7qY\u0016\u001cuN\\:v[\u0016\u0014\bBB4\u0001A\u0003%\u0001-A\btS6\u0004H.Z\"p]N,X.\u001a:!\u0011\u001dI\u0007A1A\u0005\u0002)\f1CZ3uG\"\u0014V-];fgR\u0014U/\u001b7eKJ,\u0012a\u001b\t\u0003Y>l\u0011!\u001c\u0006\u0003]\u0012\t1!\u00199j\u0013\t\u0001XNA\nGKR\u001c\u0007NU3rk\u0016\u001cHOQ;jY\u0012,'\u000f\u0003\u0004s\u0001\u0001\u0006Ia[\u0001\u0015M\u0016$8\r\u001b*fcV,7\u000f\u001e\"vS2$WM\u001d\u0011\t\u000bQ\u0004A\u0011I;\u0002\r\u0011|wk\u001c:l)\u00051\bC\u0001\nx\u0013\tA8C\u0001\u0003V]&$\b")
public class ReplicaFetcher
extends ShutdownableThread {
    public final BrokerEndPoint kafka$tools$ReplicaFetcher$$sourceBroker;
    private final Iterable<TopicAndPartition> topicAndPartitions;
    public final ReplicaBuffer kafka$tools$ReplicaFetcher$$replicaBuffer;
    public final int kafka$tools$ReplicaFetcher$$fetchSize;
    private final boolean doVerification;
    private final SimpleConsumer simpleConsumer;
    private final FetchRequestBuilder fetchRequestBuilder;

    public SimpleConsumer simpleConsumer() {
        return this.simpleConsumer;
    }

    public FetchRequestBuilder fetchRequestBuilder() {
        return this.fetchRequestBuilder;
    }

    @Override
    public void doWork() {
        CountDownLatch verificationBarrier;
        CountDownLatch fetcherBarrier;
        block5: {
            FetchResponse response;
            block4: {
                fetcherBarrier = this.kafka$tools$ReplicaFetcher$$replicaBuffer.getFetcherBarrier();
                verificationBarrier = this.kafka$tools$ReplicaFetcher$$replicaBuffer.getVerificationBarrier();
                this.topicAndPartitions.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaFetcher $outer;

                    public final FetchRequestBuilder apply(TopicAndPartition topicAndPartition) {
                        return this.$outer.fetchRequestBuilder().addFetch(topicAndPartition.topic(), topicAndPartition.partition(), this.$outer.kafka$tools$ReplicaFetcher$$replicaBuffer.getOffset(topicAndPartition), this.$outer.kafka$tools$ReplicaFetcher$$fetchSize);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                FetchRequest fetchRequest = this.fetchRequestBuilder().build();
                this.debug((Function0<String>)new Serializable(this, fetchRequest){
                    public static final long serialVersionUID = 0L;
                    private final FetchRequest fetchRequest$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Issuing fetch request ").append((Object)this.fetchRequest$1).toString();
                    }
                    {
                        this.fetchRequest$1 = fetchRequest$1;
                    }
                });
                response = null;
                try {
                    response = this.simpleConsumer().fetch(fetchRequest);
                }
                finally {
                    if (response != null) break block4;
                }
                this.topicAndPartitions.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaFetcher $outer;

                    public final void apply(TopicAndPartition topicAndPartition) {
                        ByteBufferMessageSet x$9 = MessageSet$.MODULE$.Empty();
                        short x$10 = FetchResponsePartitionData$.MODULE$.$lessinit$greater$default$1();
                        long x$11 = FetchResponsePartitionData$.MODULE$.$lessinit$greater$default$2();
                        this.$outer.kafka$tools$ReplicaFetcher$$replicaBuffer.addFetchedData(topicAndPartition, this.$outer.kafka$tools$ReplicaFetcher$$sourceBroker.id(), new FetchResponsePartitionData(x$10, x$11, x$9));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                break block5;
            }
            response.data().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaFetcher $outer;

                public final void apply(Tuple2<TopicAndPartition, FetchResponsePartitionData> x0$8) {
                    Tuple2<TopicAndPartition, FetchResponsePartitionData> tuple2 = x0$8;
                    if (tuple2 != null) {
                        TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
                        FetchResponsePartitionData partitionData = (FetchResponsePartitionData)tuple2._2();
                        this.$outer.kafka$tools$ReplicaFetcher$$replicaBuffer.addFetchedData(topicAndPartition, this.$outer.kafka$tools$ReplicaFetcher$$sourceBroker.id(), partitionData);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        fetcherBarrier.countDown();
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Done fetching";
            }
        });
        fetcherBarrier.await();
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Ready for verification";
            }
        });
        if (this.doVerification) {
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Do verification";
                }
            });
            this.kafka$tools$ReplicaFetcher$$replicaBuffer.verifyCheckSum((Function1<String, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Object x) {
                    Predef$.MODULE$.println(x);
                }
            });
            this.kafka$tools$ReplicaFetcher$$replicaBuffer.createNewFetcherBarrier();
            this.kafka$tools$ReplicaFetcher$$replicaBuffer.createNewVerificationBarrier();
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Created new barrier";
                }
            });
            verificationBarrier.countDown();
        }
        verificationBarrier.await();
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Done verification";
            }
        });
    }

    public ReplicaFetcher(String name, BrokerEndPoint sourceBroker, Iterable<TopicAndPartition> topicAndPartitions, ReplicaBuffer replicaBuffer, int socketTimeout, int socketBufferSize, int fetchSize, int maxWait, int minBytes, boolean doVerification) {
        this.kafka$tools$ReplicaFetcher$$sourceBroker = sourceBroker;
        this.topicAndPartitions = topicAndPartitions;
        this.kafka$tools$ReplicaFetcher$$replicaBuffer = replicaBuffer;
        this.kafka$tools$ReplicaFetcher$$fetchSize = fetchSize;
        this.doVerification = doVerification;
        super(name, ShutdownableThread$.MODULE$.$lessinit$greater$default$2());
        this.simpleConsumer = new SimpleConsumer(sourceBroker.host(), sourceBroker.port(), socketTimeout, socketBufferSize, ReplicaVerificationTool$.MODULE$.clientId());
        this.fetchRequestBuilder = new FetchRequestBuilder().clientId(ReplicaVerificationTool$.MODULE$.clientId()).replicaId(Request$.MODULE$.DebuggingConsumerId()).maxWait(maxWait).minBytes(minBytes);
    }
}

