/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser.format;

import org.beanio.internal.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldPadding {
    public static final char RIGHT = 'R';
    public static final char LEFT = 'L';
    private char filler = (char)32;
    private char justify = (char)76;
    private int length = 0;
    private String defaultText = "";
    private String paddedNull = "";
    private boolean optional;
    private Class<?> propertyType;

    public void init() {
        if (this.propertyType == null) {
            this.defaultText = "";
            this.optional = false;
        } else {
            this.propertyType = TypeUtil.toWrapperClass(this.propertyType);
            if (Character.class.isAssignableFrom(this.propertyType)) {
                this.defaultText = Character.toString(this.filler);
                this.optional = false;
            } else if (Number.class.isAssignableFrom(this.propertyType) && Character.isDigit(this.filler)) {
                this.defaultText = Character.toString(this.filler);
            }
        }
    }

    public String pad(String text) {
        int currentLength;
        if (text == null) {
            if (this.optional) {
                return this.paddedNull;
            }
            text = "";
            currentLength = 0;
        } else {
            if (this.length < 0) {
                return text;
            }
            currentLength = text.length();
            if (currentLength == this.length) {
                return text;
            }
            if (currentLength > this.length) {
                return text.substring(0, this.length);
            }
        }
        int remaining = this.length - currentLength;
        StringBuilder s = new StringBuilder(this.length);
        if (this.justify == 'L') {
            s.append(text);
            for (int i = 0; i < remaining; ++i) {
                s.append(this.filler);
            }
        } else {
            for (int i = 0; i < remaining; ++i) {
                s.append(this.filler);
            }
            s.append(text);
        }
        return s.toString();
    }

    public String unpad(String fieldText) {
        int length = fieldText.length();
        if (this.justify == 'L') {
            int index = fieldText.length();
            do {
                if (--index >= 0) continue;
                return this.defaultText;
            } while (fieldText.charAt(index) == this.filler);
            if (index == length - 1) {
                return fieldText;
            }
            return fieldText.substring(0, index + 1);
        }
        for (int index = 0; index < length; ++index) {
            if (fieldText.charAt(index) == this.filler) continue;
            if (index == 0) {
                return fieldText;
            }
            return fieldText.substring(index, length);
        }
        return this.defaultText;
    }

    public char getFiller() {
        return this.filler;
    }

    public void setFiller(char filler) {
        this.filler = filler;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public char getJustify() {
        return this.justify;
    }

    public void setJustify(char justify) {
        this.justify = justify;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean required) {
        this.optional = required;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(Class<?> type) {
        this.propertyType = type;
    }

    protected void setPaddedNull(String paddedNull) {
        this.paddedNull = paddedNull;
    }
}

